/*
 *  * Copyright (C) 2000-2003 ASANO Masahiro
 *   */

#ifndef THREADSIZE_H
#define THREADSIZE_H

#ifdef THREAD_SIZE	/* THREAD_SIZE may defined asm/processor.h */

#define STACKSIZE	THREAD_SIZE

#else /*THREAD_SIZE*/

#if defined(ARCH_alpha) || defined(ARCH_cris) || defined(ARCH_i386) || defined(ARCH_m68k) || defined(ARCH_mips) || defined(ARCH_ppc) || defined(ARCH_ppc64) || defined(ARCH_s390) || defined(ARCH_x86_64)
#define THREAD_LOG_SIZE   1
#define	STACKSIZE	(PAGE_SIZE << THREAD_LOG_SIZE)
#elif defined(ARCH_ia64)
#define THREAD_LOG_SIZE   IA64_TASK_STRUCT_LOG_NUM_PAGES
#define	STACKSIZE	32768
#elif defined(ARCH_mips64) || defined(ARCH_parisc) || defined(ARCH_s390x) || defined(ARCH_um)
#define THREAD_LOG_SIZE   2
#define	STACKSIZE	(PAGE_SIZE << THREAD_LOG_SIZE)
#else
#define THREAD_LOG_SIZE   0
#define	STACKSIZE	(PAGE_SIZE << THREAD_LOG_SIZE)
#endif

#endif /*THREAD_SIZE*/

#endif /*THREADSIZE_H*/
