/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t list_head();
const commandtable_t command_list_head =
	{"list_head", list_head, "[-s] address", "print list_head table\n  -s  search statically only"};
PRIVATE void prhead_list_head();
PRIVATE addr_t print_list_head();

PRIVATE void
prhead_list_head()
{
	mprintf(SPTR "  " SPTR " " SPTR "  NAME\n", "ADDR", "NEXT", "PREV");
}

PRIVATE addr_t
print_list_head(addr, sflag)
	addr_t addr;
	int sflag;
{
	struct list_head lh;
	const struct symtable *p;

	memread(addr, sizeof(lh), &lh, "list_head");
	mprintf(FPTR "  " FPTR " " FPTR "  ", addr, lh.next, lh.prev);

	if ((p = searchsym_byaddr(addr)) != NULL) {
		if (addr == p->addr) {
			mprintf("%s\n", p->name);
		} else {
			mprintf("%s+%lx\n", p->name, addr - p->addr);
		}
	} else if (sflag == 1) {
		mprintf("\n");
	} else if (search_task(addr)) {
	} else if (search_slab(addr)) {
	} else {
		mprintf("\n");
	}
	return (addr_t)lh.next;
}

PRIVATE addr_t
list_head()
{
	int c;
	int sflag = 0;
	addr_t addr, start;

	while ((c = getopt(argcnt, args, "s")) != EOF) {
		switch (c) {
		case 's':
			sflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	while (args[optind]) {
		prhead_list_head();
		start = getvalue(args[optind]);
		addr = start;
		do {
			addr = print_list_head(addr, sflag);
		} while (addr && start != addr);
		optind++;
	}

	return 0;
}
