/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t device();
const commandtable_t command_device =
	{"device", device, "address", "print device table"};
extern void prhead_device();
extern addr_t print_device();

PRIVATE addr_t
device()
{
	int c;
	int full = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	prhead_device();
	while (args[optind]) {
		addr = print_device(getvalue(args[optind]), full);
		optind++;
	}
	return addr;
}
