/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mempool.h>

void
prhead_mempool()
{
	mprintf(SPTR"  MIN CURR "SPTR" "SPTR" "SPTR" "SPTR" "SPTR"\n",
		"ADDR", "ELEMENTS", "POOLDATA", "ALLOC", "FREE", "WAIT");
}

addr_t
print_mempool(addr, full, name)
	addr_t addr;
	int full;
	const char *name;
{
	mempool_t mp;

	memread(addr, sizeof(mp), &mp, "mempool_t");
	mprintf(FPTR " ", addr);
	mprintf("%4x %4x ", mp.min_nr, mp.curr_nr);
	mprintf(FPTR " " FPTR " ", mp.elements, mp.pool_data);
	mprintf(FPTR " " FPTR " ", mp.alloc, mp.free);

	if ((addr_t)mp.wait.task_list.next == addr + OFFSET(mempool_t, wait.task_list)) {
		mprintf(SPTR, "-");
	} else {
		mprintf(FPTR, (addr_t)mp.wait.task_list.next);
	}

	if (name) {
		mprintf(" %s\n", name);
	} else {
		mprintf("\n");
	}
	return 0;
}
