/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t bio_vec();
const commandtable_t command_bio_vec =
	{"bio_vec", bio_vec, "address", "print bio_vec table"};
extern void prhead_bio_vec();
extern addr_t print_bio_vec();

PRIVATE addr_t bio();
const commandtable_t command_bio =
	{"bio", bio, "address", "print bio table"};
extern void prhead_bio();
extern addr_t print_bio();

PRIVATE addr_t
bio_vec()
{
	int c;
	int full = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	prhead_bio_vec();
	while (args[optind]) {
		print_bio_vec(getvalue(args[optind]), full);
		optind++;
	}
	return 0;
}

PRIVATE addr_t
bio()
{
	int c;
	int full = 0;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	prhead_bio();
	while (args[optind]) {
		addr = print_bio(getvalue(args[optind]), full);
		optind++;
	}
	return addr;
}
