/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t tty_struct();
const commandtable_t command_tty_struct =
	{"tty_struct", tty_struct, "address", "print tty_struct table"};
extern addr_t print_tty_struct();
extern void prhead_tty_struct();

PRIVATE addr_t
tty_struct()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	} else {
		prhead_tty_struct();
		while (args[optind]) {
			addr = print_tty_struct(getvalue(args[optind]));
			optind++;
		}
	}
	return addr;
}
