/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t svc_export();
const commandtable_t command_svc_export =
	{"svc_export", svc_export, "address", "print svc_export table"};
extern void prhead_svc_export();
extern addr_t print_svc_export();

PRIVATE addr_t svc_client();
const commandtable_t command_svc_client =
	{"svc_client", svc_client, "[-f] [address]", "print svc_client table"};
extern void prhead_svc_client();
extern addr_t print_svc_client();

addr_t clients_addr;

PRIVATE addr_t
svc_export()
{
	int c;
	int full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	prhead_svc_export();
	while (args[optind]) {
		print_svc_export(getvalue(args[optind]), full);
		optind++;
	}
	return 0;
}

PRIVATE addr_t
svc_client()
{
	int c;
	int full = 0;
	addr_t addr;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		GETADDR(clients);
		memread(clients_addr, sizeof(addr), &addr, "clients");
		if (!full) prhead_svc_client();
		while (addr) {
			if (full) prhead_svc_client();
			addr = print_svc_client(addr, full);
		}

	} else {
		if (!full) prhead_svc_client();
		while (args[optind]) {
			if (full) prhead_svc_client();
			print_svc_client(getvalue(args[optind]), full);
			optind++;
		}
	}

	return 0;
}
