/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include <linux/major.h>
#include "crash.h"

PRIVATE addr_t blk_dev_struct(), request_queue();
const commandtable_t command_blk_dev_struct =
	{"blk_dev_struct", blk_dev_struct, "[address]", "print blk_dev_struct table"};
const commandtable_t command_request_queue =
	{"request_queue", request_queue, "address", "print request_queue table"};

PRIVATE addr_t blk_dev_addr;

extern addr_t print_blk_dev_struct();
extern addr_t print_request_queue();
extern addr_t print_request();
extern void prhead_blk_dev_struct();

PRIVATE addr_t
blk_dev_struct()
{
	int c, i;
	addr_t addr;
	int full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;	break;
		default:
			THROW(usage);
		}
	}

	GETADDR(blk_dev);

	prhead_blk_dev_struct();
	if (argcnt == optind) {
		for (i = 0; i < MAX_BLKDEV; i++) {
			(void) print_blk_dev_struct(blk_dev_addr, i, full);
		}
	} else {
		while (args[optind]) {
			addr = getvalue(args[optind]);
			if (addr < MAX_BLKDEV) {
				(void) print_blk_dev_struct(blk_dev_addr, (int)addr, full);
			} else {
				(void) print_blk_dev_struct(addr, -1, full);
			}
			optind++;
		}
	}
	return 0;
}

PRIVATE addr_t
request_queue()
{
	int c;
	int full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;	break;
		default:
			THROW(usage);
		}
	}
	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void) print_request_queue(getvalue(args[optind]), full);
		optind++;
	}
	return 0;
}

addr_t
request()
{
	int c, full = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;	break;
		default:
			THROW(usage);
		}
	}
	if (argcnt == optind) {
		THROW(usage);
	}
	while (args[optind]) {
		(void) print_request(getvalue(args[optind]), full);
		optind++;
	}
	return 0;
}
