/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t swap_info();
const commandtable_t command_swap_info =
	{"swap_info", swap_info, "", "print swap_info table"};

extern addr_t print_swap_info();
extern void prhead_swap_info();

addr_t swap_info_addr;
addr_t swap_list_addr;
addr_t total_swap_pages_addr;
addr_t nr_swap_pages_addr;

PRIVATE addr_t
swap_info()
{
	addr_t addr = 0;
	int i, c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	GETADDR(swap_info);
	GETADDR(swap_list);

	prhead_swap_info();
	if (optind == argcnt) {
		int total_swap_pages, nr_swap_pages;

		addr = -1;
		do {
			addr = print_swap_info(addr);
		} while (addr != -1);

		GETADDR(total_swap_pages);
		GETADDR(nr_swap_pages);
		memread(total_swap_pages_addr, sizeof(total_swap_pages), &total_swap_pages, "total_swap_pages");
		memread(nr_swap_pages_addr, sizeof(nr_swap_pages), &nr_swap_pages, "nr_swap_pages");
		mprintf("swap_pages: %x/%x\n", nr_swap_pages, total_swap_pages);
	} else {
		for (i = optind; i < argcnt; i++) {
			if (i > optind)
				mprintf("\n");
			addr = print_swap_info(getvalue(args[i]));
		}
	}
	return addr;
}
