/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>
#include <ctype.h>

#include "token.h"


#define TOKEN_ALLOC_SIZE 3

#ifdef	SJIS
#define issjiskanji(c)	((0x81 <= (unsigned char)(c&0xff) && (unsigned char)(c&0xff) <= 0x9f)	\
	|| (0xe0 <= (unsigned char)(c&0xff) && (unsigned char)(c&0xff) <= 0xfc))
#else
#define	issjiskanji(c)	0
#endif


int setToken(char *buf, int len, TOKEN *token, char *token_separate){

  int token_start;
  int token_len;
  int i;
  
  token->token = NULL;
  token->size = 0;
  token->no = 0;
  
  token_start = 0;
  for(i = 0; i < len; i ++){

    if(issjiskanji(buf[i])){
      i++;
    }
    else if(strchr(&token_separate[0], buf[i]) != NULL){
      token_len = i - token_start;
      if(token_len > 0){
	addToken(token, &buf[token_start], token_len);
      }
      token_start = i + 1;
    }
  }
  token_len = i - token_start;
  if(token_len > 0){
    addToken(token, &buf[token_start], token_len);
  }
  return(0);

}


int setTokenStrict(char *buf, int len, TOKEN *token, char *token_separate){
  int token_start;
  int token_len;
  int i;
  
  token->token = NULL;
  token->size = 0;
  token->no = 0;
  
  token_start = 0;
  for(i=0; i < len; i++){
    // 1 byte
    if(issjiskanji(buf[i])){
      i ++;
    }
    else if(strchr(&token_separate[0], buf[i])!=NULL){
      token_len = i - token_start;
      addToken(token, &buf[token_start], token_len);
      token_start = i + 1;
    }
  }
  token_len = i - token_start;
  if(token_len > 0){
    addToken(token, &buf[token_start], token_len);
  }
  return(0);
}



int addToken(TOKEN *token, char *buf, int len)
{
  int pack_flag;
  
  pack_flag = 0;
  if(buf[0] == '"' && buf[len - 1] == '"'){
    pack_flag = 1;
  }
  else if(buf[0] == '\'' && buf[len - 1] == '\''){
    pack_flag = 1;
  }
  
  if(token->size == 0){
    token->size = TOKEN_ALLOC_SIZE;
    token->token = (char **)malloc(token->size*sizeof(char *));
    token->token[token->no] = (char *)malloc(len+1);
    if(pack_flag == 0){
      memcpy(token->token[token->no], buf, len);
      token->token[token->no][len] = '\0';
    }else{
      memcpy(token->token[token->no], buf + 1, len - 2);
      token->token[token->no][len-2] = '\0';
    }
    token->no ++;
  }else{
    if(token->no + 1 >= token->size){
      token->size += TOKEN_ALLOC_SIZE;
      token->token = (char **)realloc((char *)token->token, token->size * sizeof(char *));
      //printf("alloc=%d\n", token->size * sizeof(char *));
    }
    token->token[token->no] = (char *)malloc(len + 1);
    if(pack_flag == 0){
      memcpy(token->token[token->no], buf, len);
      token->token[token->no][len] = '\0';
    }else{
      memcpy(token->token[token->no], buf + 1, len - 2);
      token->token[token->no][len-2] = '\0';
    }
    token->no ++;
  }
  
  return(0);
}




//ִ:token[n]ʬ䤷keyȰפ硢dataִ
//(token,status,READY,$): each line  test$status$hoge ->test$READY$hoge
//sep1ʸΤ
int replaceToken(TOKEN *token, char *key, char *data, char *sep, int flag){
  int i,j,size;
  TOKEN token_local;
  char *tmp,*tmp2;
  int change_flag;

  for(i = 0; i < token->no; i++){
    change_flag = 0;

    //ƹԤ򤵤˥ȡʬ
    if(flag == 0){
      setToken(token->token[i], strlen(token->token[i]), &token_local, sep);
    }else{
      setTokenStrict(token->token[i], strlen(token->token[i]), &token_local, sep);
    }

    size = 0;
    for(j=0; j < token_local.no; j++){
      if(!strncmp(token_local.token[j], key, strlen(key))){
	tmp=(char *)malloc(strlen(data) + 1);
	strncpy(tmp, data, strlen(data) + 1);
	free(token_local.token[j]);
	token_local.token[j] = tmp;
	change_flag = 1;
      }
      size += strlen(token_local.token[j]);
    }
    
    //subХåե1ĤˤĤʤ
    if(change_flag == 1){
      tmp2 = tmp = (char *)malloc(size+token_local.no);
      for(j = 0; j < token_local.no; j++){
	strncpy(tmp, token_local.token[j], strlen(token_local.token[j]));
	tmp = tmp+strlen(token_local.token[j]);
	*tmp = *sep;
	tmp ++;
      }
      tmp --;
      *tmp = '\0';

      free(token->token[i]);
      token->token[i] = tmp2;
    }
    freeToken(&token_local);
  }
  
  return 0;
}

int replaceToken(TOKEN *token, char *key, char *data, char *sep){
  replaceToken(token, key, data, sep, 0);
}

int replaceTokenStrict(TOKEN *token, char *key, char *data, char *sep){
  replaceToken(token, key, data, sep, 1);
}

//replaceToken
int replaceToken(TOKEN *token, char *key, int data, char *sep){
  char buf[20];
  sprintf(buf, "%d", data);
  replaceToken(token, key, buf, sep);
}




int freeToken(TOKEN *token){
  int i;
  
  for(i = 0; i < token->no; i++){
    free(token->token[i]);
  }
  if(token->size > 0){
    free(token->token);
  }
  token->token = NULL;
  token->size = 0;
  token->no = 0;
  
  return(0);
}


int getToken(TOKEN *token, char *key, char *dest,int num){

  if(token->no >= num){
    if(strncmp(token->token[0], key, strlen(key))==0){
      strcpy(dest, token->token[num]);
    }
  }
  return 0;
}

// donnot alloc memory
int getToken(TOKEN *token, char *key, char *dest){
  getToken(token, key, dest, 1);
  return 0;
}


int getToken(TOKEN *token, char *key, int *dest){
  if(token->no == 2){
    if(strncmp(token->token[0], key, strlen(key))==0){
      *dest = atoi(token->token[1]);
    }
  }
  return 0;
}





//key:valuekey˰פvalueФ
int getVal(char *buf, char *key, char *sep){
  TOKEN token;
  int val = 0;
  setToken(buf,strlen(buf), &token, sep);
  getToken(&token, key, &val);
  freeToken(&token);
  return val;
}

// over
//key:valuekey˰פvalueʸȤƼФ
void getVal(char *buf, char *key, char *sep, char *dest, int num){
  TOKEN token;
  setToken(buf,strlen(buf), &token, sep);
  getToken(&token, key, dest, num);
  freeToken(&token);
  
}

void getVal(char *buf, char *key, char *sep, char *dest){
  
  getVal(buf, key, sep, dest, 1);
  
}

