/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>

#include "sock.h"

#define MAX_HOST_NAME 256

char *host_to_ipstr(char *hostname){

  struct hostent *myhost;
  struct in_addr *aptr;

  if((myhost = (struct hostent *)gethostbyname(hostname)) == NULL) {
    fprintf(stderr,"bad hostname! /etc/hosts is correct?\n");
    return NULL;
  }  
  
  aptr = (struct in_addr *)*myhost->h_addr_list;
  //fprintf(stderr, "gethostbyname%s\n",inet_ntoa(*aptr));

  return inet_ntoa(*aptr);
  
  
}

char *GetMyIp(void){

  char hostname[257];
  struct hostent *myhost;
  struct in_addr *aptr;

  gethostname(hostname, 256);
  if((myhost = (struct hostent *)gethostbyname(hostname)) == NULL) {
    fprintf(stderr,"bad hostname! /etc/hosts is correct?\n");
    return NULL;
  }  
  
  aptr = (struct in_addr *)*myhost->h_addr_list;
  //fprintf(stderr, "gethostbyname%s\n",inet_ntoa(*aptr));
  return inet_ntoa(*aptr);
  
}


/* åȽ:UDP */
int InitSocketUdp(int portno){

   char	hostname[MAX_HOST_NAME];
   struct hostent	*myhost;
   struct sockaddr_in	me;
   int	opt;
   int	soc;
   struct in_addr	*aptr;
   
   
   if(gethostname(hostname,MAX_HOST_NAME) == -1){
      perror("gethostname");
      return(-1);
   }
   fprintf(stderr, "gethostname=%s\n", hostname);
   
   
   if((myhost=gethostbyname(hostname)) == NULL){
      perror("gethostbyname");
      return(-1);
   }
   aptr = (struct in_addr *)*myhost->h_addr_list;
   fprintf(stderr, "gethostbyname=%s\n", inet_ntoa(*aptr));

   if((soc = socket(AF_INET, SOCK_DGRAM, 0)) < 0){      
      perror("socket");
      return(-1);
   }
   
   opt = 1;
   if(setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, (char *)&opt, sizeof(int)) != 0){
      perror("setsockopt");
      return(-1);
   }
   
   
   memset((char *)&me, 0, sizeof(me));
   me.sin_family = AF_INET;
   me.sin_addr.s_addr = htonl(INADDR_ANY);
   me.sin_port   = htons(portno);

   
   if(bind(soc,(struct sockaddr *)&me, sizeof(me)) == -1){
      perror("bind");
      return(-1);
   }
   return(soc);
}



/* åȽ:TCP */
int InitSocketTcp(int portno)
{
   char	hostname[MAX_HOST_NAME];
   struct hostent	*myhost;
   struct sockaddr_in	me;
   int	opt;
   int	soc;
   struct in_addr	*aptr;
   
   
   if(gethostname(hostname, MAX_HOST_NAME) == -1){
      perror("gethostname");
      return(-1);
   }
   fprintf(stderr,"gethostname=%s\n", hostname);
   
   
   if((myhost = gethostbyname(hostname)) == NULL){
      perror("gethostbyname");
      return(-1);
   }
   aptr = (struct in_addr *)*myhost->h_addr_list;
   fprintf(stderr,"gethostbyname=%s\n", inet_ntoa(*aptr));

   if((soc = socket(AF_INET,SOCK_STREAM, 0)) < 0){      
      perror("socket");
      return(-1);
   }
   
   opt = 1;
   if(setsockopt(soc, SOL_SOCKET, SO_REUSEADDR, (char *)&opt, sizeof(int)) != 0){
      perror("setsockopt");
      return(-1);
   }
   
   memset((char *)&me, 0, sizeof(me));
   me.sin_family = AF_INET;
   me.sin_addr.s_addr = htonl(INADDR_ANY);
   me.sin_port   = htons(portno);

   
   if(bind(soc, (struct sockaddr *)&me, sizeof(me)) == -1){
      perror("bind");
      return(-1);
   }
   fprintf(stderr, "initialized\n");
   return(soc);
}

