/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "recv_list.h"
#include "misc.h"

//-  Queue---Address1->Address2->Address3
//
void recv_init(RECVLIST *pnew){
  //listνǥեͤ

  pnew->sess_id = 0;
  pnew->count   = 0;
  pnew->action  = 0;
  
  return;
}


//-¤֤褦˥󥵡
RECVLIST *recv_insert(RECVLIST **phead, int sess_id, int action, void(*func)(int)){

   RECVLIST *plist, *pnew, *plist_bak;
   plist = *phead;
   
   //顼
   if(sess_id == 0){
     log(WARNING, "recv_insert\n");
     return NULL;
   }

   pnew = (RECVLIST *)malloc(sizeof(RECVLIST));
   recv_init(pnew);
   
   pnew->sess_id = sess_id;
   pnew->action  = action;
   pnew->func    = func;
   
   //ܤΥꥹȤ   
   if(*phead == NULL){
      pnew->prev = NULL;
      pnew->next = NULL;
      *phead = pnew;
      return pnew;
   }
   

   //idޤǿʤ
   while(plist != NULL && plist->sess_id <= sess_id){
     plist_bak = plist;
     plist = plist->next;
   }


   
   if(*phead == plist){
     //Ƭɲ
     pnew->prev = NULL;
     pnew->next = plist;
     plist->prev = pnew;
     *phead = pnew;
     
   }else{
     
     //plist_bakμ֤ɲä
     if(plist != NULL){
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = plist;
       plist->prev = pnew;
       
     }else{
       //Ǹξ
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = NULL;
       
     }
   }

   return pnew;
}

//ꥹȤꤵ줿ݥ󥿤ΥꥹȤ
RECVLIST *recv_delete(RECVLIST **phead, RECVLIST *pdel){


  RECVLIST *plist;

  //ꥹȤĤξ
  if(pdel->prev == NULL && pdel->next == NULL){
    free(pdel);
    *phead = NULL;
    return NULL;
  }

  //ꥹȤƬξ
  if(pdel->prev == NULL){
    pdel->next->prev = NULL;
    plist = pdel->next;
    free(pdel);
    *phead = plist;
    return plist;
  }

  //ꥹȤǸξ
  if(pdel->next == NULL){
    pdel->prev->next = NULL;
    free(pdel);
    return NULL;
  }

  //ꥹȤ֤ξ
  plist = pdel->next;
  pdel->prev->next = pdel->next;
  pdel->next->prev = pdel->prev;
  free(pdel);

  //ΥꥹȤ֤
  return plist;


}


//ꥹȤKEY򸵤˺
RECVLIST *recv_delete_key(RECVLIST **phead, int sess_id){

   RECVLIST *plist, *pbak;
   plist = *phead;
   
   while( plist != NULL && plist->sess_id < sess_id){
      plist = plist->next;
   }
   
   while( plist != NULL && plist->sess_id == sess_id){
     //ΥꥹȤ֤ʤNULL
     plist = recv_delete(phead, plist);
   }
   
   //ΥꥹȤ֤
   return plist;
}



//ꥹȤ饭ͤ¸ߤ뤫
//ҥåȤʤ0֤
RECVLIST *recv_search(RECVLIST *plist, int sess_id){
  
  RECVLIST *list_local;
  list_local = plist;
   

  while(list_local != NULL && list_local->sess_id < sess_id){
    list_local = list_local->next;
  }
  
  if(list_local != NULL && list_local->sess_id == sess_id){
    return list_local;
  }
  
  
  return NULL;

}


//ꥹȤοĴ٤
int recv_size(RECVLIST *plist){

   int count;
   RECVLIST *list_local;
   list_local = plist;

   count = 0;
   while(list_local != NULL){
      count ++;
      list_local = list_local->next;
   }
   
   return count;

}

//ꥹȤΰɽǥХå
void recv_print(RECVLIST **plist){

   int count;
   char buf[32];
   count=0;
   RECVLIST *list_local;
   list_local = *plist;
   
   while(list_local != NULL){

     log(NOTICE, "%d:SESSID=%u\n", count, list_local->sess_id);
     count++;

     list_local = list_local->next;
   }


}
















