/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/


#ifndef __PROTOCOL
#define __PROTOCOL
class MChord;
//#include "mchord.h"
#include "task_list.h"


class Protocol{
  
 private:
  MChord *mMChord;

  void  SendData(ADDRESS address, char *data);

 public:
  Protocol();
  void SetMChord(MChord *pMChord);
  int  SocketInit(int port);

  void RecvPacket(int sock);

  void JoinRoom(char *room_name);

  void SendAck(ADDRESS address, int sessid);
  void RecvAck(ADDRESS address, char *data);
  void RecvAckWait(ADDRESS address, char *data);
  void RecvAckReset(ADDRESS address, char *data);
  
  void SendJoin(ADDRESS address, int sessid, int BeginId, int SeqNo);
  void RecvJoin(ADDRESS address, char *buff);

  void SendJoinRedirect(ADDRESS address, int sessid, int SeqNo, int ip, 
			int port);
  void RecvJoinRedirect(ADDRESS address, char *buff);

  void SendFile(ADDRESS address, char *data, int size, int seqno, int sessid, 
		int mcid, int fileseqno, int flag);
  void RecvFile(ADDRESS address, char *buff);
  
  void SendJoinAccept(ADDRESS address, int SessId, ADDRESS next, int EndId,
		      int SeqNo);
  void TaskAddUpdateRT(ADDRESS address, int SessId, int mcid);
  void RecvJoinAccept(ADDRESS address, char *buff);


  void SendLookup(ADDRESS address, int sessid, int mcid_to, int mcid_from, 
		  int Ttl, int SeqNo, ADDRESS address_src);
  void RecvLookup(ADDRESS address, char *buff);//call by switch

  void SendLookupResponse(ADDRESS Address, int SessId, int McId, int SeqNo, 
			  int Ttl, int Ans, int mcid2);
  void RecvLookupResponse(ADDRESS address, char *buff);

  void SendLeave(ADDRESS address, int sessid, ADDRESS next, int BeginId, 
		 int EndId, int SeqNo);
  void RecvLeave(ADDRESS address, char *buff);

  void SendLeaveEnd(ADDRESS address, int sessid, int SeqNo);
  void RecvLeaveEnd(ADDRESS address, char *buff);

  void SendMessage(ADDRESS address, int SeqNo, char *data);
  void RecvMessage(ADDRESS address, char *buff);

  void SendInsert(ADDRESS address, char *data, int size, int key, int SeqNo);
  void RecvInsert(ADDRESS address, char *buff);
  
  void SendData(ADDRESS Address, char *Data, int Size, int Func, int SeqNo);
  void AddHeadder(char *buff, int size, int func, int sequenceno);
  void SendExe (ADDRESS address, char *data, int size);
  void message(char *fmt, ...);
  

};


#endif
