/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "parser.h"
#include "misc.h"

#define XML_MAX_LEN     10000
#define MAX_STACK_LEVEL   100

#define BUFF_IS_NULL     9998
#define TAG_ERROR        9999

XML::XML(char *buff, int size){

  
  mCurrentLevel = 0;
  mCurrentNumber = 0;
  mCurrentPointer = NULL;
  mBuffXML = NULL;
  
  mStatusXML = 0;
  mTmpBuff = NULL;
  mLenXML = size;

  if(mLenXML > XML_MAX_LEN || mLenXML == 0){
    mLenXML = 0;
    return;
  }
  
  mCurrentPointer = mBuffXML = (char *)malloc(mLenXML + 1);
  memcpy(mBuffXML, buff, mLenXML);
  *(mBuffXML + mLenXML) = '\0';
  mStatusXML = parse();
  if(mStatusXML != 0){
    //log(INFORMATION, "StatusXML = %d\n", mStatusXML);
    printf("Error: StatusXML = %d Level = %d\n\n", mStatusXML, mCurrentLevel);
  }
  
}


XML::~XML(){
 
  // free memory
  if(mTmpBuff != NULL){
    free(mTmpBuff);
  }
  if(mBuffXML != NULL){
    free(mBuffXML);
  }

}


int XML::parse(){
  char *current = mCurrentPointer;
  int stack_level = 0;
  
  // check buffer
  if(mBuffXML == NULL){
    return BUFF_IS_NULL;
  }
  //printf("XML=%s\n", current);
  // check tag
  while(current != NULL && 
	(stack_level == 0 || stack_level == 1)){
    current = strpbrk(current, "<>");
    if(current != NULL && *current == '<'){
      //printf("%d find <\n", stack_level);
      stack_level ++;
      
    }
    
    if(current != NULL && *current == '>'){
      //printf("%d find >\n", stack_level);
      stack_level --;      
    }

    if(current != NULL){
      current ++;
    }
    
  }
  
  if(stack_level != 0){
    return TAG_ERROR;
  }
  
  

  
  // check stack level
  int end_flg = 0;
  stack_level = 0;
  while(stack_level >= 0 && stack_level <= MAX_STACK_LEVEL && end_flg == 0){
    //printf("currentLevel = %d\n", mCurrentLevel);

    if(firstChild() != 0){
      //printf("child\n");
      stack_level ++;
      continue;
    }
    

    if(nextSiblingNeighbor() != 0){
      //printf("sibling\n");
      continue;
    }

    if(parentNode() != 0){
      //printf("parent\n");
      stack_level --;
    }else{
      end_flg = 1;
    }
    
    
  }

  mCurrentLevel = 0;
  mCurrentNumber = 0;
  mCurrentPointer = mBuffXML;
  
  return stack_level;

}
  
  
int XML::insertData(int pointer, char *buff){
  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }
  
}


int XML::firstChild(){
  if(mStatusXML != 0 || mCurrentPointer == NULL){

    return 0;
  }

  char *slash_gt;
  char *lt_slash;
  char *lt;
  char *gt;
  char *current;
  
  slash_gt = strstr(mCurrentPointer, "/>");
  lt_slash = strstr(mCurrentPointer, "</");
  lt       = strchr(mCurrentPointer, '<');
  gt       = strchr(mCurrentPointer, '>');
  
  if(lt == NULL || gt == NULL){
    return 0;
  }


  // this tag is self open and closed
  if(slash_gt != NULL && ++slash_gt == gt ){
    return 0;
  }

  // tag is closed
  if(lt_slash != NULL && lt_slash == lt){
    return 0;
  }
  
  // move to next tag
  if(gt == NULL){
    return 0;
  }

  current = gt;
  
  // next tag is closed
  lt_slash = strstr(current, "</");
  lt       = strchr(current, '<');

  if(lt == NULL || lt_slash == NULL){
    return 0;
  }

  // tag is closed
  if(lt == lt_slash){
    return 0;
  }
  

  mCurrentPointer = lt;
  mCurrentNumber = mCurrentPointer - mBuffXML; 
  mCurrentLevel ++;
  return -1;

}

int XML::parentNode(){

  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }
  //  printf("XML-=%s\n", mCurrentPointer);
  char *slash_gt;
  char *lt_slash;
  char *lt;
  char *gt;
  char *current;

  gt       = strchr(mCurrentPointer, '>');
  slash_gt = strstr(mCurrentPointer, "/>");
  lt_slash = strstr(mCurrentPointer, "</");
  lt       = strchr(mCurrentPointer, '<');

  // check end only 1 stack_level 
  if(gt == NULL || lt == NULL){
    return 0;
  }

  // this tag is closed
  if(lt_slash != NULL && lt_slash == lt){
    // move to next new tag
    current = strchr(lt, '>');
    if(current == NULL){
      return 0;
    }
    current = strchr(current, '<');
    mCurrentPointer = current;
    mCurrentLevel --;
    mCurrentNumber = mCurrentPointer - mBuffXML;
    
    return -1;
  }

  
  // if it not finished /> then check next start tag
  if(slash_gt != NULL && gt < ++slash_gt || slash_gt == NULL){
    lt_slash = strstr(gt, "</");
    lt = strchr(gt, '<');
    //    printf("XML0=%s\n",lt);
    if(lt == NULL || lt_slash == NULL){
      return 0;
    }

    // has child
    if(lt < lt_slash){
      return 0;
    }
    
  }

  //printf("XML1=%s\n",lt);

  // move to next new tag
  current = strchr(lt, '>');
  if(current == NULL){
    return 0;
  }


  current = strchr(current, '<');
  if(current == NULL){
    return 0;
  }
  //printf("XML2=%s\n",current);
  
  // tag has been closed
  // tag doesn't have child

  // check next tag
  lt       = strchr(current, '<');
  lt_slash = strstr(current, "</");  
  if(lt == NULL){
    return 0;
  }
  

  // have sibling
  if(lt_slash != NULL && lt < lt_slash){
    return 0;
  }

  // lt == lt_slash
  // goto next tag
  current = strchr(lt, '>');
  if(current == NULL){
    return 0;
  }
  //printf("XML3=%s\n",current);  
  current = strchr(current, '<');
  mCurrentPointer = current;
  mCurrentLevel --;
  mCurrentNumber = mCurrentPointer - mBuffXML;


  // return -1 when mCurrentPointer is NULL
  return -1;
  
  
}



int XML::nextSibling(){


  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }
  
  if(nextSiblingNeighbor() == -1){
    return -1;
  }

  
  
  // check stack level
  int end_flg = 0;
  int stack_level = 0;

  do{
    //printf("currentLevel = %d\n", mCurrentLevel);
    
    if(firstChild() != 0){
      //printf("child\n");
      stack_level ++;
      continue;
    }
    
    
    if(nextSiblingNeighbor() != 0){
      //printf("sibling\n");
      continue;
    }
    
    if(parentNode() != 0){
      //printf("parent\n");
      stack_level --;
    }else{
      end_flg = 1;
    }
  
  }while(stack_level > 0 && end_flg == 0);
  
  
}



int XML::nextSiblingNeighbor(){  
  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }

  char *slash_gt;
  char *lt_slash;
  char *lt;
  char *gt;
  char *current;
  //printf("XML=%s\n", mCurrentPointer);
  gt       = strchr(mCurrentPointer, '>');
  slash_gt = strstr(mCurrentPointer, "/>");
  lt = strchr(mCurrentPointer, '<');  
  // check end only 1 stack_level
  
  if(gt == NULL){
    return 0;
  }
  
  // if it not finished /> then check next start tag
  if(slash_gt != NULL && gt < ++slash_gt){
    lt_slash = strstr(gt, "</");

    if(lt == NULL || lt_slash == NULL){
      return 0;
    }

    if(lt < lt_slash){
      return 0;
    }
        
  }

  // move to next new tag
  current = strchr(lt, '>');
  if(current == NULL){
    return 0;
  }
  current = strchr(current, '<');
  if(current == NULL){
    return 0;
  }
  
  //printf("XML2=%s\n", current);
  // tag has been closed
  // tag doesn't have child

  // check next tag
  lt       = strchr(current, '<');
  lt_slash = strstr(mCurrentPointer, "</");  
  if(lt == NULL || lt_slash == NULL){
    return 0;
  }
    
  // next is parent
  if(lt == lt_slash){
    return 0;
  }
  

  mCurrentPointer = lt;
  mCurrentNumber = mCurrentPointer - mBuffXML;
  
  return -1;
  
}
  

int XML::createElement(char *value){
  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }

}

int XML::createTextNode(char *value){
  // working
  
}

int XML::setAttributes(char *key, char *value){
  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return 0;
  }
  // working

}



char *XML::getAttributes(char *key){
  char *gt;
  char *value_start;
  char *value_end;
  char *ret;

  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return NULL;
  }
  
  if(mTmpBuff != NULL){
    free(mTmpBuff);
    mTmpBuff = NULL;
  }
  
  gt = strchr(mCurrentPointer, '>');
  value_start = strstr(mCurrentPointer, key);
  if(value_start != NULL && value_start < gt){
    // check abc is matched as ab
    if(strpbrk(value_start + strlen(key), "= ") != (value_start + strlen(key))){return NULL;}
    
    value_start = strchr(value_start, '\"');
    value_start ++;
    value_end = strchr(value_start, '"');
    if(value_end != NULL && value_end != value_start ){
      ret = (char *)malloc(value_end - value_start + 1);
      memcpy(ret, value_start, value_end - value_start);
      *(ret + (value_end - value_start)) = '\0';
      return ret;
    }
    
  }
  return NULL;
}

char *XML::toString(){
  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return NULL;
  }
  // working

}

char *XML::getCurrentPointer(){
  return mCurrentPointer;

}


char *XML::nodeName(){
  
  char *value_start;
  char *value_end;
  char *ret;

  if(mStatusXML != 0 || mCurrentPointer == NULL){
    return NULL;
  }
  
  if(mTmpBuff != NULL){
    free(mTmpBuff);
    mTmpBuff = NULL;
  }

  // next to '<' to cancel space
  value_start = strchr(mCurrentPointer, '<');
  value_start ++;
  while(value_start != NULL && *value_start == ' '){
    value_start ++;
  }

  value_end = strpbrk(value_start, " =");

  if(value_end != NULL && value_end != value_start ){
    ret = (char *)malloc(value_end - value_start + 1);
    memcpy(ret, value_start, value_end - value_start);
    *(ret + (value_end - value_start)) = '\0';
    return ret;
  }
  
  return NULL;
}
