/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "protocol.h"
#include "mchord.h"
#include "app.h"
#include "config.h"
#include "sock.h"
#include "misc.h"
#include "control.h"

#include "parser.h"

//global class
MChord   *pMChord;

#define DEFAULT_PORT 4649

int main( int argc, char *argv[] )
{

  int  sock;
  int  port;
  int  log_flg;
  char cache_dir[256];
  int  Ip;

  int listen_tcp_fd, listen_udp_fd;

  Protocol *pProtocol;

  //initalize
  port = DEFAULT_PORT;
  cache_dir[0] = '\0';
  log_flg = 0;

  //  char buff[]="<test><tete><test geho = \"test \" /><sib gege=\"3\" /></tete><hoge /></test>";
  //  XML *pXML;
  //  pXML = new XML(buff, strlen(buff));
  //  fprintf(stderr, "\n");
  //  fprintf(stderr, "debug = %s\n",pXML->getCurrentPointer());
  //  pXML->firstChild();
  //  pXML->firstChild();
  //  fprintf(stderr, "ret=[%s]\n",pXML->getAttributes("geho"));
  //  fprintf(stderr, "ret=[%s]\n",pXML->getAttributes("gehoo"));
  //  fprintf(stderr, "debug = %s\n",pXML->getCurrentPointer());
  //  pXML->nextSibling();
  //  fprintf(stderr, "debug = %s\n",pXML->getCurrentPointer());
  //  fprintf(stderr, "\n");

  //decode option
  //          in    in    out    out        out
  if((Options(argc, argv, &port, cache_dir, &log_flg)) == -1){
    return -1;
  }
  

  //create protocol class
  //pProtocol = new SimProtocol();
  pProtocol = new Protocol();

  //GetMyIp
  Ip = str_to_ip(GetMyIp());


  // initialize socket
  listen_tcp_fd = InitSocketTcp(port);
  listen_udp_fd = InitSocketUdp(port);


  //create mchord class
  pMChord   = new MChord(pProtocol, port, listen_udp_fd, cache_dir, log_flg, Ip);
  
  
  // initialize application
  // set callback function
  init_app(&argc, &argv);
  
  
  // main controller
  control(listen_tcp_fd, listen_udp_fd);

  return(0);       

}


