/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/
#include <sys/time.h>


#ifndef __LIST
#define __LIST

// type
#define UDP      0
#define TCP_CONN 1
#define TCP_DATA 2

typedef struct _LIST {

  int  id;
  int  type;
  int  recv_flg;
  struct timeval start_time;
  
  struct _LIST *prev;
  struct _LIST *next;
}LIST;

#endif

LIST *insert(LIST **phead, int id, int type, struct timeval start_time);
LIST *delete_key(LIST **phead, int id);
LIST *delete_list(LIST **phead, LIST *pdel);


LIST *search(LIST *plist, int id);
int  size(LIST *plist);
void print(LIST **plist);



