/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "list.h"

//-  Address1->Address2->Address3
//
void init(LIST *pnew){
  //listνǥեͤ

  pnew->id = 0;
  return;
}


//-¤֤褦˥󥵡
LIST *insert(LIST **phead, int id, int type, struct timeval start_time){

   LIST *plist, *pnew, *plist_bak;
   plist = *phead;

   //顼
   if(id == 0){
     fprintf(stderr, "id_insert\n");
     return NULL;
   }

   pnew = (LIST *)malloc(sizeof(LIST));
   init(pnew);
   
   pnew->id = id;
   pnew->type = type;
   pnew->start_time = start_time;
   pnew->recv_flg = 0;

   //ܤΥꥹȤ   
   if(*phead == NULL){
      pnew->prev = NULL;
      pnew->next = NULL;
      *phead = pnew;
      return pnew;
   }
   

   //idޤǿʤ
   while(plist != NULL && plist->id <= id){
     plist_bak = plist;
     plist = plist->next;
   }


   
   if(*phead == plist){
     //Ƭɲ
     pnew->prev = NULL;
     pnew->next = plist;
     plist->prev = pnew;
     *phead = pnew;
     
   }else{
     
     //plist_bakμ֤ɲä
     if(plist != NULL){
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = plist;
       plist->prev = pnew;
       
     }else{
       //Ǹξ
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = NULL;
       
     }
   }

   return pnew;
}

//ꥹȤꤵ줿ݥ󥿤ΥꥹȤ
LIST *delete_list(LIST **phead, LIST *pdel){


  LIST *plist;

  //ꥹȤĤξ
  if(pdel->prev == NULL && pdel->next == NULL){
    free(pdel);
    *phead = NULL;
    return NULL;
  }

  //ꥹȤƬξ
  if(pdel->prev == NULL){
    pdel->next->prev = NULL;
    plist = pdel->next;
    free(pdel);
    *phead = plist;
    return plist;
  }

  //ꥹȤǸξ
  if(pdel->next == NULL){
    pdel->prev->next = NULL;
    free(pdel);
    return NULL;
  }

  //ꥹȤ֤ξ
  plist = pdel->next;
  pdel->prev->next = pdel->next;
  pdel->next->prev = pdel->prev;
  free(pdel);

  //ΥꥹȤ֤
  return plist;


}


//ꥹȤKEY򸵤˺
LIST *delete_key(LIST **phead, int id){

   LIST *plist, *pbak;
   plist = *phead;
   
   while( plist != NULL && plist->id < id){
      plist = plist->next;
   }

   while( plist != NULL && plist->id == id){
     //ΥꥹȤ֤ʤNULL
     plist = delete_list(phead, plist);
   }
   
   //ΥꥹȤ֤
   return plist;
}



//ꥹȤ饭ͤ¸ߤ뤫
//ҥåȤʤ0֤
LIST *search(LIST *plist, int id){
  
  LIST *list_local;
  list_local = plist;
   

  while(list_local != NULL && list_local->id < id){
    list_local = list_local->next;
  }
  
  if(list_local != NULL && list_local->id == id){
    return list_local;
  }
  
  
  return NULL;

}


//ꥹȤοĴ٤
int size(LIST *plist){

   int count;
   LIST *list_local;
   list_local = plist;

   count = 0;
   while(list_local != NULL){
      count ++;
      list_local = list_local->next;
   }
   
   return count;

}

//ꥹȤΰɽǥХå
void print(LIST **plist){

   int count;
   char buf[32];
   count = 0;
   LIST *list_local;
   list_local = *plist;
   

   while(list_local != NULL){

     fprintf(stderr, "%d:ID=%u\n", count, list_local->id);
     count++;

     list_local = list_local->next;
   }


}
















