/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include "token.h"
#include "http.h"
#include "mchord.h"


extern MChord  *pMChord;

#define LINE_BUFF_MAX 2000
#define SOC_TIMEOUT     3
#define PATH_PREFIX (".")


MT mediaTypes[] = {
  {"html","text/html"},
  {"txt", "text/plain"},
  {"log", "text/plain"},
  {"jpeg","image/jpeg"},
  {"gif", "image/gif"},
  {"png", "image/png"},
  {"swf", "application/x-shockwave-flash"},
  {NULL,  NULL}
};


char* getMediaType(char* extension){

  int i;
  for( i = 0; mediaTypes[i].extension != NULL; i ++ ){
    if( strcasecmp(mediaTypes[i].extension, extension) == 0 )
      return mediaTypes[i].mediaType;
  }

  return NULL;
}


int sendData(int s, char* buf){

  int ret;
  if(checkSend(s, SOC_TIMEOUT) == -1){
    fprintf(stderr, "warn!");
    return -1;
  }
  ret = send(s, buf, strlen(buf), 0);
  if(ret <= 0){
    fprintf(stderr, "cannot send\n");
  }
  return ret;
}


//send formated data
int sendFmtData(int s, char* fmt,...){
  va_list ap;
  char buf[1024];
  
  va_start(ap, fmt);
  vsprintf(buf, fmt, ap);
  return sendData(s, buf);

}

int receiveLine(int s, char* line){
  unsigned char ch, prev_ch = 0x0;
  while(1){//over flow
    
    if(recv(s, &ch, 1, 0) <= 0 ){
      *line = '\0';
      printf("ERROR-\n");//cannot recognize last buffer
      return -1;
      break;
    }

    if( ch == 0xa && prev_ch == 0xd ){
      line --;
      *line = '\0';
      return 0;
      break;
    }
    *line = prev_ch = ch;
    *line ++;
  }
  
}


void sendHeader(int s,char* type,int length){
  sendData(s, "HTTP/1.0 200 OK\r\n");
  sendFmtData(s, "Content-Type: %s\r\n", type);
  sendFmtData(s, "Content-Length: %d\r\n", length);
  sendData(s, "\r\n");
}

void sendNotFound(int s){
  char* html = "<html><head></head><body>File Not Found<br>matchat 1.1</body></html>";
  sendData(s, "HTTP/1.0 404 Not Found\r\n");
  sendData(s, "Content-Type: text/html\r\n");
  sendFmtData(s, "Content-Length: %d\r\n", strlen(html));
  sendData(s, "\r\n");
  sendData(s, html);
}

void sendError(int s){
  char* html = "<html><head></head><body>Nandeyanen</body></html>";
  sendData(s, "HTTP/1.0 404 Nandeyanen\r\n");
  sendData(s, "Content-Type: text/html\r\n");
  sendFmtData(s, "Content-Length: %d\r\n", strlen(html));
  sendData(s, "\r\n");
  sendData(s, html);

}

void sendHtml(TOKEN *token, int s, char *mediaType){
  
  int i;
  int size = 0;
  
  //UpdateHtml(token);
  //CutSeparate(token, "$");
  
  for(i = 0; i < token->no; i++){
    size += strlen(token->token[i]);
  }
  
  sendHeader(s, mediaType, size);
  for(i = 0; i < token->no; i ++){
    if( send(s, token->token[i], strlen(token->token[i]), 0) < 0 ){
      //error();
      fprintf(stderr,"soc write error\n");
      break;
    }
  }
  
}


void sendFile(int s,char* path){
  FILE* fpin = fopen(path,"r");
  char buf[512];
  int  readbyte;
  struct stat sb;
  char* p;
  char* mediaType;
  if( fpin == NULL ){
    sendNotFound(s);
    return;
  }
  fstat(fileno(fpin), &sb);
  if((p = strrchr(path, '.')) != NULL){
    p ++;
    mediaType = getMediaType(p);
    if( mediaType == NULL ){
      sendNotFound(s);
      return;
    }
  }
  else {
    sendNotFound(s);
    return;
  }
  
  if(!strcmp(mediaType, "text/html")){
    TOKEN token;
    char buff[2000];
    
    token.token = NULL;
    token.size = 0;
    token.no = 0;
    while(fgets(buff, LINE_BUFF_MAX, fpin) != NULL){
      addToken(&token, buff, sizeof(buff));
    }
    sendHtml(&token, s, mediaType);
  }else{
    
    sendHeader(s, mediaType, sb.st_size);
    while( (readbyte = fread(buf, 1, 512, fpin)) != 0 ){
      if( send(s, buf, readbyte, 0) < 0 ){
	break;
      }
    }
    
  }
  fclose(fpin);
}



void sendResponse(int s, char* request){
  char path[512], uri[512];
  char* p;
  struct stat sb;

  if(request == NULL){
    return;
  }

  if(strncmp(request,"GET ", 4) && strncmp(request, "POST ", 5)){
    sendError(s);
    return;
  }
  
  if(!strncmp(request, "GET", 3)){
    sscanf(request, "GET %511s", uri);
  }else{
    sscanf(request, "POST %511s", uri);
  }
  
  p = uri + strlen(uri) - 1;

  // last character is /
  if( *p == '/' ){
    *p = '\0';
  }

  sprintf(path, "%s%s", PATH_PREFIX, uri);

  if(stat(path, &sb) < 0 ){
    sendNotFound(s);
    return;
  }

  if((sb.st_mode & S_IFDIR) != 0 ){
    strcat(path, "/index.html");
    sendFile(s, path);
  } else {
    sendFile(s, path);
  }

}

int checkSend(int soc, int time){
  
  struct timeval  timeout;
  fd_set mask;
  int ret;

  FD_ZERO(&mask);
  FD_SET(soc, &mask);
  timeout.tv_sec  = time;
  timeout.tv_usec = 0;
      
  //select
  ret = select(soc + 1, NULL, (fd_set *)&mask, NULL, &timeout);
  if(ret <= 0){
    return -1;
  }
  
  return 0;
}

int checkReceive(int soc, int time){
  
  struct timeval timeout;
  fd_set mask;
  int ret;

  FD_ZERO(&mask);
  FD_SET(soc, &mask);
  timeout.tv_sec = time;
  timeout.tv_usec = 0;
      
  //select
  ret = select(soc + 1, (fd_set *)&mask, NULL, NULL, &timeout);
  if(ret <= 0){
    return -1;
  }
  
  return 0;
}


void http(int sock){
  int len = 0, c_len = 0;
  int n;
  char buf[1512];
  char* request = NULL;
  TOKEN token;
  
  c_len = 0;

  while(1){
    // get one line
    if(checkReceive(sock, SOC_TIMEOUT) == -1){
      break;
    }
    if(receiveLine(sock, buf) == -1){
      break;
    }
    if( request == NULL ){
      request = strdup(buf);
    }
 
    if((len = getVal(buf, "Content-Length", " :")) != 0){
      c_len = len;
    }

    if(buf[0] == '\0'){
      break;
    }
  }
  /*
  if(c_len != 0){

    receiveLine(sock,buf);
    SetToken(buf, strlen(buf), &token, "&");
    for(n = 0; n < token.no; n ++){
      SetConfig(token.token[n]);
    }
    
    FreeToken(&token);

    // write to file
    WriteConfig();
  }
  */

  sendResponse(sock, request);
  if( request ) free(request);
  close(sock);
  //shutdown(tp->sock,2);
}

