#include <stdio.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <errno.h>
#include <netinet/in.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "sock.h"
#include "error.h"
#include "list.h"
#include "mchord.h"

#include "app.h" //read_lookup_response
#include "parser.h"
#include "http.h"

#define MAX_TIMEOUT 5
#define CONN_PERIOD 10
#define BUFF_SIZE 2000

#define UDP      0
#define TCP_CONN 1
#define TCP_DATA 2

//#define RESEND
LIST *list = NULL;

extern MChord *pMChord;




//------------------------------------------------------------
// 
//------------------------------------------------------------
void receive_xml(LIST *list_local, char *buff, int size){
  XML *pXML;
  pXML = new XML(buff, size);
  
  if(pXML == NULL || pXML->nodeName() == NULL){return;}
  //  fprintf(stderr,"(%s)", buff);
  if(strcmp(pXML->nodeName(), "join") == 0){
    call_join(list_local, pXML->getAttributes("ip"));
  }
  if(strcmp(pXML->nodeName(), "login") == 0){
    call_login(list_local, pXML->getAttributes("name"), pXML->getAttributes("room"));
  }
  if(strcmp(pXML->nodeName(), "message") == 0){
    call_message(list_local, pXML->getAttributes("text"));
  }
    

}

void receive_http(LIST *list_local){
  // call http
  http(list_local->id);
  
}


void send_data(int fd){

  //char send_buff[] = "HTTP/1.1 200 OK\r\nContent-Length: 2\r\nConnection: close\r\nContent-Type: text/plain\r\n\r\nab";
  //    char send_buff[] = "<N><A a=\"test1\" /><C><B>test</B><B><F></F></B></C><D></D></N>\0";
  char send_buff[] = "<member count=\"2\"><user name=\"matsu\" ip=\"192\" /><user name=\"youki\" ip=\"163\" /></member>\0";
  //    fprintf(stderr,"data send=%d[%s]", strlen(send_buff), send_buff);
  //send(fd, send_buff, strlen(send_buff)+1, 0);
  
}


LIST *check_tcp_read(int fd, fd_set *mask, LIST *list_local){
  
  int size;
  char buff[BUFF_SIZE];
  LIST *ret = list_local;

  // check 2 TCP read fd
  if(FD_ISSET(fd, mask)){      

    // donnot erase buffer
    size = recv(fd, buff, BUFF_SIZE, MSG_PEEK);
    
    // switch http data
    if(size >0 && buff[0] == 'G' && buff[1] == 'E' && buff[2] == 'T'){
      receive_http(list_local);
    }


    size = read(fd, buff, BUFF_SIZE);
    buff[size]='\0';
    //    fprintf(stderr, "data receive=%d[%s]\n", size, buff);

    // error
    if(size <= 0 ){
      //      fprintf(stderr, "connection closed by client\n");
      ret = delete_key((LIST **)&list, fd);
      shutdown(fd, SHUT_RDWR);
      close(fd);
      return ret;
    }
    


    list_local->recv_flg = 1;

    // switch xml or http
    receive_xml(list_local, buff, size);

      


#ifndef RESEND
    //send_data(fd);
    //ret = delete_key((LIST **)&list, fd);
    //shutdown(fd, SHUT_RDWR);
    //close(fd);
#endif

    
    // send login
    //if(size == 5){
    // fprintf(stderr, "send login\n");
      //pMChord->SendLookupData("ideon", recv_lookup_response);
    //}


  }

  return ret;
}


int check_tcp_connection(int listen_tcp_fd, fd_set *mask, struct sockaddr_in *from){

  int size;
  int len;
  int acc;
  struct timeval now;
  struct timezone tz;


  // new tcp connection
  if(FD_ISSET(listen_tcp_fd, mask)){
    //    fprintf(stderr, "connected\n");
    
    /* å³ */
    len = sizeof(from);
    acc = accept(listen_tcp_fd, (struct sockaddr *)&from,(socklen_t *)&len);
    if(acc <= 0){
      //      if(errno == EMFILE){fprintf(stderr, "EMFILE");}
      //      fprintf(stderr, "%d\n",EINVAL);
      //      fprintf(stderr, "%d\n",EMFILE);
      exit(0);
      return 0;
    }
    
    //    fprintf(stderr, "make client\n");
    gettimeofday(&now, &tz);
    
    insert((LIST **)&list, acc, TCP_DATA, now);
    
  }

  return -1;

}

void check_udp_read(int listen_udp_fd, fd_set *mask, struct sockaddr_in *from){
  
  int size;
  char buff[BUFF_SIZE];
  socklen_t fromlen;

  
  // check UDP read fd
  if(FD_ISSET(listen_udp_fd, mask)){
    //fromlen = sizeof(from);
    //size = recvfrom(listen_udp_fd, buff, BUFF_SIZE, 0, (sockaddr *)&from, &fromlen);

    //fprintf(stderr, "data receive=%d\n",size);
    pMChord->RecvPacket(listen_udp_fd);

  }
  return;

}


//******************************************
// check read from socket
//  -> call check_tcp_connection
//  -> call check_tcp_read
//  -> call check_udp_read
//******************************************
void check_read(fd_set *mask, struct sockaddr_in *from){
  
  int ret;
  LIST *list_local = list;
  
  while(list_local != NULL){
    
    // TCP Connection
    if(list_local->type == TCP_CONN){
      // check tcp new connection
      ret = check_tcp_connection(list_local->id, mask, from);
      if( ret == 0){
	errout(errno, ret, "accept error");
      }
    }
    
    // TCP Data
    if(list_local->type == TCP_DATA){    
      // check tcp read
      list_local = check_tcp_read(list_local->id, mask, list_local);
    }
 
    // UDP Connection & Data
    if(list_local != NULL && list_local->type == UDP){
      check_udp_read(list_local->id, mask, from);
    }
    
    if(list_local != NULL){
      list_local = list_local->next;
    }

  }

}


void set_timer( struct timeval *timeout){
  
  //Set Timer
  if(timeout->tv_sec == 0 && timeout->tv_usec == 0){
    timeout->tv_sec = MAX_TIMEOUT;
    timeout->tv_usec = 0;
  }

}

void timer(){
  
  LIST *list_local = list;
  struct timeval  now;
  struct timezone tz;
  int fd;
  gettimeofday(&now, &tz);
  while(list_local != NULL){
    
    if( list_local->type == TCP_DATA 
        && (now.tv_sec - list_local->start_time.tv_sec) > CONN_PERIOD){
      //fd = list_local->id;
      //delete_key((LIST**)&list, fd);
      //shutdown(fd, SHUT_RDWR);
      //close(fd);
    }
      
    list_local = list_local->next;
  }
  
  
  // call mchord 
  pMChord->TimerFunc();
  
}

void call_timer( struct timeval *timeout){
  
  if(timeout->tv_sec == 0 && timeout->tv_usec == 0){
    timer();
  }

}

int set_mask(fd_set *mask, int listen_tcp_fd, int listen_udp_fd, int fd){

  int width;
  LIST *list_local = list;

  // initialize mask
  FD_ZERO(mask);

  while(list_local != NULL){
    
    FD_SET(list_local->id, mask);
    width = list_local->id;

    list_local = list_local->next;
  }
  
  
  //set width + 1
  width ++;

  return width;

}

void free_socket(){
  
  int fd;
  LIST *list_local = list;
 
  while(list_local != NULL){
    
    if(list_local->type == TCP_DATA){
      fd = list_local->id;
      delete_key((LIST**)&list, fd);
      shutdown(fd, SHUT_RDWR);
      close(fd);
    }
    
    list_local = list_local->next;
  }
}



void resend(){
  struct timeval  timeout;
  fd_set mask;
  int ret;
  int fd;

  LIST *list_local = list;
  
  while(list_local != NULL){
    if(list_local->type == TCP_DATA){
      FD_ZERO(&mask);
      FD_SET(list_local->id, &mask);
      timeout.tv_sec  = 0;
      timeout.tv_usec = 0;
      
      //select
      ret = select(list_local->id + 1, NULL, (fd_set *)&mask, NULL, &timeout);
      if(ret <= 0 || list_local->recv_flg == 0){
	//return -1;
      }else{

	send_data(list_local->id);

	//fd = list_local->id;
	//list_local = delete_key((LIST **)&list, fd);
	//shutdown(fd, SHUT_RDWR);
	//close(fd);
      }

    }
    if(list_local != NULL)
      list_local = list_local->next;
  }

}


int control(int listen_tcp_fd, int listen_udp_fd){
  
  int fd = 0;
  int    width;
  int    n,ret,len;
  
  fd_set mask;
  struct sockaddr_in   from;
  struct timeval  timeout;
  struct timezone tz;
  char buff[BUFF_SIZE];

  if(listen_tcp_fd <= 0 || listen_udp_fd <= 0){
    fprintf(stderr, "Init sock error\n");
    return 0;
  }

  gettimeofday(&timeout, &tz);

  insert((LIST **)&list, listen_tcp_fd, TCP_CONN, timeout);
  insert((LIST **)&list, listen_udp_fd, UDP, timeout);

  // listen
  listen(listen_tcp_fd, SOMAXCONN);
  
  // initialize timer
  timeout.tv_sec  = 0;
  timeout.tv_usec = 0;
  set_timer(&timeout);
  

  // main loop
  while(1){

    // set mask
    width = set_mask(&mask, listen_tcp_fd, listen_udp_fd, fd);
    
    
    // select
    ret = select(width, (fd_set *)&mask, NULL, NULL, &timeout);
    if(ret < 0){
      errout(errno, ret, "select error!!");
      break;
    }
    
    // check udp read
    check_read(&mask, &from);
    
    // call timer
    call_timer(&timeout);
    
    // set timer
    set_timer(&timeout);
    
#ifdef RESEND
    // resend
    //resend();
#endif

    // debug
    //print((LIST **)&list);

  }
  
  // release resource
  free_socket();
  pMChord->Quit();
  
  return -1;
}



