/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "app_list.h"
#include "misc.h"

void app_init(APPLIST *pnew){

  //listνǥեͤ

  pnew->ip = 0;
  pnew->port = 0;
  pnew->name = NULL;
  return;
}


//-¤֤褦˥󥵡
APPLIST *app_insert(APPLIST **phead, int ip, int port, char *name){

   APPLIST *plist, *pnew, *plist_bak;
   plist = *phead;

   //顼
   if(ip == 0){
     log(WARNING, "app_insert\n");
     return NULL;
   }
   
   pnew = (APPLIST *)malloc(sizeof(APPLIST));
   app_init(pnew);

   pnew->ip = ip;
   pnew->port = port;
   pnew->name = (char *)malloc(strlen(name) + 1);
   memcpy(pnew->name, name, strlen(name) + 1);

   //ܤΥꥹȤ   
   if(*phead == NULL){
      pnew->prev = NULL;
      pnew->next = NULL;
      *phead = pnew;
      return pnew;
   }
   

   //ipޤǿʤ
   while(plist != NULL && plist->ip <= ip){
     plist_bak = plist;
     plist = plist->next;
   }
   
   //portޤǿʤ
   while(plist != NULL && plist->port <= port){
     plist_bak = plist;
     plist = plist->next;
   }

   
   if(*phead == plist){
     //Ƭɲ
     pnew->prev = NULL;
     pnew->next = plist;
     plist->prev = pnew;
     *phead = pnew;
     
   }else{
     
     //plist_bakμ֤ɲä
     if(plist != NULL){
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = plist;
       plist->prev = pnew;
       
     }else{
       //Ǹξ
       plist_bak->next = pnew;
       pnew->prev = plist_bak;
       
       pnew->next = NULL;
       
     }
   }
   
   return pnew;
}


//ꥹȤꤵ줿ݥ󥿤ΥꥹȤ
APPLIST *app_delete(APPLIST **phead, APPLIST *pdel){
  
  APPLIST *plist;
  log(NOTICE, "DELETE\n");
  //ꥹȤĤξ
  if(pdel->prev == NULL && pdel->next == NULL){
    free(pdel->name);
    free(pdel);
    *phead = NULL;
    return NULL;
  }

  //ꥹȤƬξ
  if(pdel->prev == NULL){
    pdel->next->prev = NULL;
    plist = pdel->next;
    free(pdel->name);
    free(pdel);
    *phead = plist;
    return plist;
  }

  //ꥹȤǸξ
  if(pdel->next == NULL){
    pdel->prev->next = NULL;
    free(pdel->name);
    free(pdel);
    return NULL;
  }

  //ꥹȤ֤ξ
  plist = pdel->next;
  pdel->prev->next = pdel->next;
  pdel->next->prev = pdel->prev;
  free(pdel->name);
  free(pdel);

  //ΥꥹȤ֤
  return plist;


}


//ꥹȤKEY򸵤˺
APPLIST *app_delete_key(APPLIST **phead, int ip, int port){

   APPLIST *plist, *pbak;
   plist = *phead;
   
   while(plist != NULL){
     
     if( plist->ip == ip && plist->port == port){
       //ΥꥹȤ֤ʤNULL
       plist = app_delete(phead, plist);
     }else{
       plist = plist->next;
      
     }
   }
   
   //ΥꥹȤ֤
   return plist;
}



//ꥹȤ饭ͤ¸ߤ뤫
//ҥåȤʤ0֤
APPLIST *app_search(APPLIST *plist, int ip){
  
  APPLIST *list_local;
  list_local = plist;
   

  while(list_local != NULL && list_local->ip < ip){
    list_local = list_local->next;
  }
  
  if(list_local != NULL && list_local->ip == ip){
    return list_local;
  }
  
  
  return NULL;

}


//ꥹȤοĴ٤
int app_size(APPLIST *plist){

   int count;
   APPLIST *list_local;
   list_local = plist;

   count = 0;
   while(list_local != NULL){
      count ++;
      list_local = list_local->next;
   }
   
   return count;

}

//ꥹȤΰɽǥХå
void app_print(APPLIST **plist){

   int count;
   char buf[32];
   count=0;
   APPLIST *list_local;
   list_local = *plist;
   
   while(list_local != NULL){
     
     log(NOTICE, "%d:port[%d] name=%s\n", 
	 count, list_local->port, list_local->name);
     count++;
     list_local = list_local->next;
   }


}
















