/*******************************************************************
 *                  Light Weight Chord Library 1.0                 *
 *  CopyRight(C) Yoshihide Matsumoto IDEON WorkingGroup 2003,2004  *
 *      matsumoto333@yahoo.co.jp (http://www.matchan.mydns.jp)     *
 *                                                                 *
 * Implementation of chord (Distributed Hash Table)                *
 * This program is distributed under GPL                           *
 * Light Weight Chord Library comes with ABSOLUTELY NO WARRANTY.   *
 * This is free software, and you are welcome to redistribute it   *
 * under certain conditions; read `COPYING' for details.           *
 *******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "app.h"
#include "main.h"
#include "protocol.h"
#include "mchord.h"
#include "misc.h"
#include "app_list.h"
#include "list.h"


#define MAX_BUFF 128
#define MAX_MEMBER 1000



//global
extern MChord *pMChord;
extern LIST   *list;

APPLIST   *pip_list;
char gName[MAX_BUFF];

int init_app(int *argc, char ***argv){
  
  int ret;
  
  //set call back function
  pMChord->SetCallBackRecvMessage(send_message_local);
  gName[0] = '\0';
  return ret;

}



void send_answer_local(LIST *list_local, char *status, char *state){
  char *buff;
  int len;
  len = strlen(status);
  len += strlen(state);
  buff = (char *)malloc(len + 100);
  sprintf(buff, "<answer status=\"%s\" state=\"%s\" />", status, state);
  send(list_local->id, buff, strlen(buff) + 1, 0);
  free(buff);
  
}

// call back by mchord
void send_member_local(int McId, char *pCacheDir){
  
  FILE *fp;
  char buf[129];
  char file_name[50];
  char *start;
  char *name;
  char *ip;
  int  count = 0;
  char xml[1024];
  char *current_xml;
  LIST *list_local;

  sprintf(file_name,"./%s/%d", pCacheDir, McId);
  fp = fopen(file_name,"r");



  if(fp == NULL){
    fprintf(stderr, "main: cannot open file = %s\n", file_name);
    return;
  }
  
  sprintf(xml,"<member>");
  current_xml = &xml[8];
  //delete member list
  
  
  //open file
  while(fgets(buf,128,fp) != NULL && count < MAX_MEMBER){
    start = strchr(buf, ',');
    if(start != NULL){
      *start = '\0';
      name = &buf[0];
      ip   = &start[1];
      start = strchr(&start[1], '\n');
      if(start != NULL){
	*start = '\0';
      }
      //xml_list_append
    }
    // buffer over flow
    sprintf(current_xml, "<user name=\"%s\" ip=\"%s\" />", name, ip);
    current_xml = current_xml + strlen(current_xml);
    count ++;
  }
  sprintf(current_xml, "</member>");

  // send all flash client
  list_local = list;
  while(list_local != NULL){
    if(list_local->id > 0 && list_local->type == TCP_DATA){
      send(list_local->id, xml, strlen(xml) + 1, 0);
    }
    list_local = list_local->next;
  }
  
  fclose(fp);
  
}

// call back by mchord
// when message is received
void send_message_local(char *text){

  char buf[MAX_BUFF];
  char *start;
  char *name;
  char *msg;
  LIST *list_local;

  //  fprintf(stderr,"((%s))\n",text);
  
  start = strstr(text, "&gt;");
  if(start != NULL){
    start[0]='\0';//&
    start[1]='\0';//g
    start[2]='\0';//t
    start   = &start[3];
  }

  if(start == NULL){
    start = strchr(text, '>');
  }
  
  if(start != NULL){
    *start = '\0';
    name = &text[0];
    msg = &start[1];
    start = strchr(&start[1], '\n');
    if(start != NULL){
      *start = '\0';
    }
        
  }


  sprintf(&buf[0], "<message text=\"%s&gt;%s\" />",name, msg);
  
  // send all flash client
  list_local = list;
  while(list_local != NULL){
    if(list_local->id > 0 && list_local->type == TCP_DATA){
      send(list_local->id, &buf[0], strlen(&buf[0]) + 1, 0);
    }
    list_local = list_local->next;
  }


}



void call_join(LIST *list_local, char *ip){
  //  fprintf(stderr, "call_join[%s]\n", ip);
  send_answer_local(list_local, "ok", "fine");
  pMChord->Join(&ip[0]);
}


void call_login(LIST *list_local, char *name, char *room){
  //  fprintf(stderr, "call_login[%s][%s]\n", name, room); 
  
  // save name to global buffer
  strncpy(gName, name, MAX_BUFF - 1);
  
  // SendLookup, set callback function
  pMChord->SendLookupData(room, recv_lookup_response);
  
}

//-----------------------------------------------------------
// receive from private domain
// send to global domain
//-----------------------------------------------------------
void call_message(LIST *list_local, char *text){


  char buf[MAX_BUFF];

  ADDRESS Address;
  char ipbuff[32];  
  APPLIST *plist;
  plist = pip_list;
  
  // buffer over flow
  sprintf(&buf[0], "%s&gt;%s", gName, text);//black

  //send message to all node
  while(plist != NULL){
    if(plist->ip != pMChord->GetIp() || plist->port != pMChord->GetPort()){
      log(NOTICE, "send message to %s:%d\n", plist->name, plist->port);
      ip_to_str(plist->ip, ipbuff);
      Address.Ip   = plist->ip;
      Address.Port = plist->port;
      // send global
      pMChord->SendMessage(Address, &buf[0]);
    }
    plist = plist->next;
  }
  
  // send to local too.
  send_message_local(&buf[0]);
  
}



void file2iplist(int McId){
  
  FILE *fp;
  char buf[32];
  char file_name[50];
  char *start;
  char *ip;
  int  port;
  char *name;
  
  sprintf(file_name,"./%s/%d", pMChord->GetCacheDir(), McId);
  fp = fopen(file_name,"r");

  if(fp == NULL){   
    fprintf(stderr, "main: cannot open file = %s\n",file_name);
    fp = fopen(file_name, "w");
    fclose(fp);
    return;
  }


  //open file
  while(fgets(buf, 30, fp) != NULL){

    start = strchr(buf, ',');

    if(start != NULL){
      *start = '\0';
      name = &buf[0];
      ip = &start[1];
      start = strchr(&start[1], '\n');
      if(start != NULL){
	*start = '\0';
      }
      start = strchr(ip,':');
      if(start != NULL){
	*start = '\0';
	port = atoi(&start[1]);
      }
      app_delete_key((APPLIST **)&pip_list, str_to_ip(ip), port);
      app_insert((APPLIST **)&pip_list, str_to_ip(ip), port, name);
      
    }
  }

  fclose(fp);


}


void iplist2file(int McId){

  FILE *fp;
  char file_name[50];
  char ipbuff[32];
  
  APPLIST *plist;  
  plist = pip_list;
  
  sprintf(file_name,"./%s/%d", pMChord->GetCacheDir(), McId);
  fp = fopen(file_name, "w");

  if(fp == NULL){   
    fprintf(stderr, "main: cannot open file = %s\n", file_name);
    fclose(fp);
    return;
  }
  
  while(plist != NULL){
    log(NOTICE, "iplist2file %s:%d\n", plist->name, plist->port);
    ip_to_str(plist->ip, ipbuff);
    fprintf(fp, "%s,%s:%d\n",plist->name, ipbuff, plist->port);
    plist = plist->next;
  }
  
  fclose(fp);
  
}

// call back by mchord
void recv_lookup_response(int McId){

  int key;

  //file to mem (app_insert)
  file2iplist(McId);
  
  log(NOTICE, "app_print\n");
  app_print((APPLIST **)&pip_list);

  //delete my name
  app_delete_key((APPLIST **)&pip_list, pMChord->GetIp(), pMChord->GetPort());
  log(NOTICE, "ip=%d, port = %d\n", pMChord->GetIp(), pMChord->GetPort());
  app_print((APPLIST **)&pip_list);
  log(NOTICE, "app_deleted\n");

  // add my name to MChord
  app_insert((APPLIST **)&pip_list, pMChord->GetIp(), pMChord->GetPort(),
	     gName);
  
  app_print((APPLIST **)&pip_list);
  
  
  // mem to file
  iplist2file(McId);
  
  // send flash client
  send_member_local(McId, pMChord->GetCacheDir());  
  
  // SendInsert
  pMChord->SendInsert(McId);
    
}


//call back by gtk
void send_join(char *dist){

  
  char buf[128];
  char *buf_label;

  // check status
  if(pMChord->IsJoin()){

    // join
    pMChord->SendLeave();
    
  }else{

    // alone
    if(pMChord->Join(dist)){
      // post join
    }

  }


}


// call by mchord
void update_status(char *msg){
  
    
}





