/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogGenerator;
import org.apache.maven.changelog.ChangeLogParser;
import org.apache.maven.util.AsyncStreamReader;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;

public abstract class AbstractChangeLogGenerator
implements ChangeLogGenerator,
ExecuteStreamHandler {
    protected File base;
    protected ChangeLog changeLogExecutor;
    protected ChangeLogParser clParser;
    private String connection;
    protected String dateRange;
    protected Collection entries;
    protected AsyncStreamReader errorReader;
    protected InputStream in;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$changelog$AbstractChangeLogGenerator == null ? (class$org$apache$maven$changelog$AbstractChangeLogGenerator = AbstractChangeLogGenerator.class$("org.apache.maven.changelog.AbstractChangeLogGenerator")) : class$org$apache$maven$changelog$AbstractChangeLogGenerator));
    static /* synthetic */ Class class$org$apache$maven$changelog$AbstractChangeLogGenerator;

    public void init(ChangeLog changeLog) {
        this.changeLogExecutor = changeLog;
        this.base = this.changeLogExecutor.getBasedir();
        if (this.changeLogExecutor.getRange() != null && this.changeLogExecutor.getRange().length() != 0) {
            this.setDateRange(this.changeLogExecutor.getRange());
        }
        this.setConnection(this.changeLogExecutor.getRepositoryConnection());
    }

    protected void setDateRange(String numDaysString) {
        int days = Integer.parseInt(numDaysString);
        Date before = new Date(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        Date to = new Date(System.currentTimeMillis() + 86400000L);
        this.dateRange = this.getScmDateArgument(before, to);
    }

    public Collection getEntries(ChangeLogParser parser) throws IOException {
        if (parser == null) {
            throw new NullPointerException("parser cannot be null");
        }
        if (this.base == null) {
            throw new NullPointerException("basedir must be set");
        }
        if (!this.base.exists()) {
            throw new FileNotFoundException("Cannot find base dir " + this.base.getAbsolutePath());
        }
        this.clParser = parser;
        try {
            Execute exe = new Execute((ExecuteStreamHandler)this);
            exe.setCommandline(this.getScmLogCommand().getCommandline());
            exe.setWorkingDirectory(this.base);
            AbstractChangeLogGenerator.logExecute(exe, this.base);
            exe.execute();
            String errors = this.errorReader.toString().trim();
            if (errors.length() > 0) {
                LOG.error((Object)errors);
            }
        }
        catch (IOException ioe) {
            this.handleParserException(ioe);
        }
        return this.entries;
    }

    protected void handleParserException(IOException ioe) throws IOException {
        throw ioe;
    }

    public void cleanup() {
    }

    protected abstract Commandline getScmLogCommand();

    protected abstract String getScmDateArgument(Date var1, Date var2);

    public void stop() {
    }

    public void setProcessInputStream(OutputStream os) {
    }

    public void setProcessErrorStream(InputStream is) {
        this.errorReader = new AsyncStreamReader(is);
    }

    public void setProcessOutputStream(InputStream is) {
        this.in = is;
    }

    public void start() throws IOException {
        this.errorReader.start();
        this.entries = this.clParser.parse(this.in);
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public static void logExecute(Execute exe, File base) {
        String[] c = exe.getCommandline();
        LOG.info((Object)("SCM Working Directory: " + base));
        int i = 0;
        while (i < c.length) {
            String string = c[i];
            LOG.info((Object)("SCM Command Line[" + i + "]: " + string));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

