/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.jcoveragereport.Clazz;
import org.apache.maven.jcoveragereport.ClazzComparator;

public class Package {
    private List classes;
    private String name = "";
    private String directory;

    public Package(String name) {
        this.name = name;
        this.classes = new ArrayList();
    }

    public void setName(String name) {
        if (name == null) {
            System.out.println("Package == null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean contains(Clazz theClass) {
        return this.classes.contains(theClass);
    }

    public void addClass(Clazz theClass) {
        this.classes.add(theClass);
    }

    public List getClasses() {
        return this.classes;
    }

    public List getClassesSortedByName() {
        ClazzComparator comp = new ClazzComparator();
        Collections.sort(this.classes, comp);
        return this.classes;
    }

    public String getCoveredPercentLine() {
        return String.valueOf(this.getLineCoverage());
    }

    public String getCoveredPercentBranch() {
        double total = 0.0;
        if (this.getLineCoverage() > 0.0) {
            Iterator iter = this.getClasses().iterator();
            while (iter.hasNext()) {
                Clazz theClass = (Clazz)iter.next();
                total += (double)new Double(theClass.getBranchRate()).floatValue();
            }
            total /= (double)this.getClasses().size();
        }
        return String.valueOf(total);
    }

    private double getLineCoverage() {
        double total = 0.0;
        Iterator iter = this.getClasses().iterator();
        while (iter.hasNext()) {
            Clazz theClass = (Clazz)iter.next();
            total += (double)new Double(theClass.getLineRate()).floatValue();
        }
        return total / (double)this.getClasses().size();
    }
}

