/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jcoveragereport;

import java.io.Reader;
import org.apache.maven.jcoveragereport.Clazz;
import org.apache.maven.jcoveragereport.Coverage;
import org.apache.maven.jcoveragereport.Line;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class CoverageUnmarshaller {
    public Coverage parse(Reader reader) throws Exception {
        Coverage coverage = new Coverage();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("coverage")) {
                    coverage.setSrcDirectory(parser.getAttributeValue("", "src"));
                }
                if (parser.getName().equals("class")) {
                    Clazz theClass = new Clazz(parser.getAttributeValue("", "name"));
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("file")) {
                            String fileName = parser.getAttributeValue("", "name");
                            theClass.setFile(fileName);
                        } else if (parser.getName().equals("line") && parser.getAttributeCount() == 1) {
                            theClass.setLineRate(parser.getAttributeValue("", "rate"));
                        } else if (parser.getName().equals("line") && parser.getAttributeCount() == 2) {
                            Line line = new Line();
                            line.setNumLine(Integer.valueOf(parser.getAttributeValue("", "number")));
                            line.setNbHits(Integer.valueOf(parser.getAttributeValue("", "hits")));
                            theClass.addLine(line);
                        } else if (parser.getName().equals("branch")) {
                            theClass.setBranchRate(parser.getAttributeValue("", "rate"));
                        }
                        if (parser.getName().equals("methods")) {
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("method")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("line") || parser.getName().equals("branch")) {
                                            // empty if block
                                        }
                                        parser.next();
                                    }
                                }
                                parser.next();
                            }
                            continue;
                        }
                        parser.next();
                    }
                    coverage.addClass(theClass);
                }
            }
            eventType = parser.next();
        }
        return coverage;
    }
}

