/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.service.repository.instance;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.plexus.service.repository.ComponentHousing;
import org.apache.plexus.service.repository.ComponentManager;
import org.apache.plexus.service.repository.instance.InstanceManager;

public abstract class AbstractInstanceManager
implements InstanceManager {
    private ClassLoader classLoader;
    private Configuration configuration;
    private String implementation;
    private ComponentManager componentManager;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.implementation = configuration.getChild("implementation").getValue();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    protected ComponentHousing createInstance() throws Exception {
        ComponentHousing housing = new ComponentHousing();
        housing.setComponent(this.getClassLoader().loadClass(this.getImplementation()).newInstance());
        housing.setComponentManager(this.getComponentManager());
        this.getComponentManager().getComponentRespository().startComponentLifecycle(housing);
        return housing;
    }
}

