/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus.configuration;

import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.plexus.configuration.DefaultConfiguration;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlPullConfigurationBuilder {
    private static final int EXPECTED_DEPTH = 5;
    private final ArrayList m_elements = new ArrayList(5);
    private final ArrayList m_values = new ArrayList(5);
    private final BitSet m_preserveSpace = new BitSet();
    private Configuration m_configuration;

    public Configuration parse(Reader reader) throws Exception {
        this.clear();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String rawName = parser.getName();
                DefaultConfiguration configuration = this.createConfiguration(rawName, this.getLocationString());
                int depth = this.m_elements.size();
                boolean preserveSpace = false;
                if (depth > 0) {
                    DefaultConfiguration parent = (DefaultConfiguration)this.m_elements.get(depth - 1);
                    parent.addChild(configuration);
                    preserveSpace = this.m_preserveSpace.get(depth - 1);
                }
                this.m_elements.add(configuration);
                this.m_values.add(new StringBuffer());
                int attributesSize = parser.getAttributeCount();
                int i = 0;
                while (i < attributesSize) {
                    String name = parser.getAttributeName(i);
                    String value = parser.getAttributeValue(i);
                    if (!name.equals("xml:space")) {
                        configuration.setAttribute(name, value);
                    } else {
                        preserveSpace = value.equals("preserve");
                    }
                    ++i;
                }
                if (preserveSpace) {
                    this.m_preserveSpace.set(depth);
                } else {
                    this.m_preserveSpace.clear(depth);
                }
            } else if (eventType == 4) {
                int depth = this.m_values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)this.m_values.get(depth);
                valueBuffer.append(parser.getText());
            } else if (eventType == 3) {
                int depth = this.m_elements.size() - 1;
                DefaultConfiguration finishedConfiguration = (DefaultConfiguration)this.m_elements.remove(depth);
                String accumulatedValue = this.m_values.remove(depth).toString();
                if (finishedConfiguration.getChildren().length == 0) {
                    Object finishedValue = this.m_preserveSpace.get(depth) ? accumulatedValue : (0 == accumulatedValue.length() ? null : accumulatedValue.trim());
                    finishedConfiguration.setValue((String)finishedValue);
                } else {
                    String trimmedValue = accumulatedValue.trim();
                    if (trimmedValue.length() > 0) {
                        throw new Exception("Not allowed to define mixed content in the element " + finishedConfiguration.getName() + " at " + finishedConfiguration.getLocation());
                    }
                }
                if (0 == depth) {
                    this.m_configuration = finishedConfiguration;
                }
            }
            eventType = parser.next();
        }
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        this.m_values.clear();
    }

    protected DefaultConfiguration createConfiguration(String localName, String location) {
        return new DefaultConfiguration(localName, location);
    }

    protected String getLocationString() {
        return "Unknown";
    }
}

