/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plexus;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.plexus.DefaultPlexusContainer;

public class PlexusTestCase
extends TestCase {
    DefaultPlexusContainer container;
    public String basedir = System.getProperty("basedir");

    public PlexusTestCase(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        if (this.basedir == null) {
            this.basedir = new File("").getPath();
        }
        File f = new File(this.basedir, "target/plexus-home");
        System.setProperty("plexus.home", f.getAbsolutePath());
        if (!f.isDirectory()) {
            f.mkdir();
        }
        InputStream configuration = null;
        try {
            configuration = this.getCustomConfiguration();
            if (configuration == null) {
                configuration = this.getConfiguration();
            }
        }
        catch (Exception e) {
            System.out.println("Error with configuration:");
            System.out.println("configuration = " + configuration);
            Assert.fail((String)e.getMessage());
        }
        this.container = new DefaultPlexusContainer();
        this.container.addContextValue("basedir", this.basedir);
        this.container.addContextValue("plexus.home", System.getProperty("plexus.home"));
        this.container.setConfigurationResource(new InputStreamReader(configuration));
        this.container.initialize();
        this.container.start();
    }

    public InputStream getCustomConfiguration() throws Exception {
        return null;
    }

    public void tearDown() throws Exception {
        this.container.dispose();
        this.container = null;
    }

    protected DefaultPlexusContainer getContainer() {
        return this.container;
    }

    protected InputStream getConfiguration() throws Exception {
        return this.getConfiguration(null);
    }

    protected URL getConfigurationUrl() {
        String className = ((Object)((Object)this)).getClass().getName();
        String base = className.substring(className.lastIndexOf(".") + 1);
        String config = base + ".xml";
        return ((Object)((Object)this)).getClass().getResource(config);
    }

    protected InputStream getConfiguration(String subname) throws Exception {
        String className = ((Object)((Object)this)).getClass().getName();
        String base = className.substring(className.lastIndexOf(".") + 1);
        String config = null;
        config = subname == null || subname.equals("") ? base + ".xml" : base + "-" + subname + ".xml";
        InputStream configStream = this.getResourceAsStream(config);
        return configStream;
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected Object lookup(String componentKey) throws Exception {
        return this.getContainer().getComponentRepository().lookup(componentKey);
    }

    protected Object lookup(String role, String id) throws Exception {
        return this.getContainer().getComponentRepository().lookup(role, id);
    }

    protected Object getComponent(String componentKey) throws Exception {
        return this.lookup(componentKey);
    }

    protected Object getComponent(String componentKey, String id) throws Exception {
        return this.lookup(componentKey, id);
    }

    public String getTestFile(String path) {
        return new File(this.basedir, path).getAbsolutePath();
    }

    public String getTestFile(String basedir, String path) {
        return new File(basedir, path).getAbsolutePath();
    }
}

