/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.release;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.release.PomTransformer;
import org.apache.maven.release.Transformation;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.dom4j.Dom4jXPath;

public abstract class AbstractPomTransformer
implements PomTransformer {
    private File project;
    private Document document;
    private File outputFile;
    private Map variables;
    private List selectedNodes;
    private List transformations;

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    public void setProject(File project) {
        this.project = project;
    }

    public File getProject() {
        return this.project;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public List getSelectedNodes() {
        block2: {
            if (this.selectedNodes != null) break block2;
            try {
                this.selectNodes();
            }
            catch (Exception e) {}
        }
        return this.selectedNodes;
    }

    public void setSelectedNodes(List selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public int getSelectedNodeCount() {
        return this.getSelectedNodes().size();
    }

    public List getTransformations() {
        if (this.transformations == null) {
            this.createTransformations();
        }
        return this.transformations;
    }

    public void createTransformations() {
        this.transformations = new ArrayList();
        Iterator i = this.getSelectedNodes().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Node)) continue;
            Transformation transformation = new Transformation(this);
            transformation.setNode((Node)o);
            this.transformations.add(transformation);
        }
    }

    public void transformNodes() throws Exception {
        Iterator i = this.getSelectedNodes().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Node)) continue;
            this.transformNode((Node)o);
        }
    }

    public abstract String selectNodesXPathExpression();

    public abstract String selectNodeXPath();

    public abstract String getNodeContent(Node var1) throws Exception;

    public abstract void transformNode(Node var1) throws Exception;

    public void selectNodes() throws Exception {
        SAXReader reader = new SAXReader();
        this.setDocument(reader.read(this.getProject()));
        Dom4jXPath xpath = new Dom4jXPath(this.selectNodesXPathExpression());
        this.setSelectedNodes(xpath.selectNodes((Object)this.getDocument()));
    }

    public void write() throws Exception {
        OutputStream os = null;
        if (this.getOutputFile() != null) {
            FileUtils.copyFile((File)this.getOutputFile(), (File)new File(this.getOutputFile() + ".backup"));
            os = new FileOutputStream(this.getOutputFile());
        } else {
            os = new PrintStream(System.out);
        }
        OutputFormat format = new OutputFormat();
        format.setIndentSize(2);
        format.setNewlines(true);
        format.setTrimText(true);
        XMLWriter writer = new XMLWriter(format);
        writer.setOutputStream(os);
        writer.write(this.getDocument());
    }

    public abstract Node getTransformedNode(Node var1) throws Exception;
}

