/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl;

import java.io.StringReader;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionImpl;
import org.apache.commons.jexl.parser.ASTExpressionExpression;
import org.apache.commons.jexl.parser.ASTReferenceExpression;
import org.apache.commons.jexl.parser.Parser;
import org.apache.commons.jexl.parser.SimpleNode;

public class ExpressionFactory {
    protected static Parser parser = new Parser(new StringReader(";"));
    protected static ExpressionFactory ef = new ExpressionFactory();

    private ExpressionFactory() {
    }

    public static Expression createExpression(String expression) throws Exception {
        return ExpressionFactory.getInstance().createNewExpression(expression);
    }

    protected static ExpressionFactory getInstance() {
        return ef;
    }

    protected Expression createNewExpression(String expression) throws Exception {
        SimpleNode tree;
        String expr = expression.trim();
        if (!expr.endsWith(";")) {
            expr = expr + ";";
        }
        Parser parser = ExpressionFactory.parser;
        synchronized (parser) {
            tree = ExpressionFactory.parser.parse(new StringReader(expr));
        }
        SimpleNode node = (SimpleNode)tree.jjtGetChild(0);
        if (node instanceof ASTReferenceExpression) {
            ExpressionImpl e = new ExpressionImpl(expression, (SimpleNode)node.jjtGetChild(0));
            return e;
        }
        if (node instanceof ASTExpressionExpression) {
            ExpressionImpl e = new ExpressionImpl(expression, (SimpleNode)node.jjtGetChild(0));
            return e;
        }
        throw new Exception("Invalid expression");
    }
}

