/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class AntClassLoader
extends ClassLoader
implements BuildListener {
    private static final int BUFFER_SIZE = 8192;
    private Vector pathComponents = new Vector();
    private Project project;
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable zipFiles = new Hashtable();
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;
    private static Method getProtectionDomain = null;
    private static Method defineClassProtectionDomain = null;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$AntClassLoader;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public AntClassLoader(Project project, Path classpath) {
        this.parent = (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getClassLoader();
        this.project = project;
        project.addBuildListener((BuildListener)this);
        if (classpath != null) {
            Path actualClasspath = classpath.concatSystemClasspath("ignore");
            String[] pathElements = actualClasspath.list();
            int i = 0;
            while (i < pathElements.length) {
                try {
                    this.addPathElement(pathElements[i]);
                }
                catch (BuildException e) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public AntClassLoader(ClassLoader parent, Project project, Path classpath, boolean parentFirst) {
        this(project, classpath);
        if (parent != null) {
            this.parent = parent;
        }
        this.parentFirst = parentFirst;
        this.addSystemPackageRoot("java");
        this.addSystemPackageRoot("javax");
        this.addSystemPackageRoot("org.xml.sax");
        this.addSystemPackageRoot("org.apache.xerces");
    }

    public AntClassLoader(Project project, Path classpath, boolean parentFirst) {
        this(null, project, classpath, parentFirst);
    }

    public AntClassLoader(ClassLoader parent, boolean parentFirst) {
        if (parent != null) {
            this.parent = parent;
        } else {
            parent = (class$org$apache$tools$ant$AntClassLoader == null ? (class$org$apache$tools$ant$AntClassLoader = AntClassLoader.class$("org.apache.tools.ant.AntClassLoader")) : class$org$apache$tools$ant$AntClassLoader).getClassLoader();
        }
        this.project = null;
        this.parentFirst = parentFirst;
    }

    protected void log(String message, int priority) {
        if (this.project != null) {
            this.project.log(message, priority);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (LoaderUtils.isContextLoaderAvailable()) {
            this.savedContextLoader = LoaderUtils.getContextClassLoader();
            ClassLoader loader = this;
            if (this.project != null && "only".equals(this.project.getProperty("build.sysclasspath"))) {
                loader = this.getClass().getClassLoader();
            }
            LoaderUtils.setContextClassLoader((ClassLoader)loader);
            this.isContextLoaderSaved = true;
        }
    }

    public void resetThreadContextLoader() {
        if (LoaderUtils.isContextLoaderAvailable() && this.isContextLoaderSaved) {
            LoaderUtils.setContextClassLoader((ClassLoader)this.savedContextLoader);
            this.savedContextLoader = null;
            this.isContextLoaderSaved = false;
        }
    }

    public void addPathElement(String pathElement) throws BuildException {
        File pathComponent = this.project != null ? this.project.resolveFile(pathElement) : new File(pathElement);
        this.pathComponents.addElement(pathComponent);
    }

    public String getClasspath() {
        StringBuffer sb = new StringBuffer();
        boolean firstPass = true;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            if (!firstPass) {
                sb.append(System.getProperty("path.separator"));
            } else {
                firstPass = false;
            }
            sb.append(((File)enumeration.nextElement()).getAbsolutePath());
        }
        return sb.toString();
    }

    public void setIsolated(boolean isolated) {
        this.ignoreBase = isolated;
    }

    public static void initializeClass(Class theClass) {
        Constructor<?>[] cons = theClass.getDeclaredConstructors();
        if (cons != null && cons.length > 0 && cons[0] != null) {
            Object[] strs = new String[256];
            try {
                cons[0].newInstance(strs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void addSystemPackageRoot(String packageRoot) {
        this.systemPackages.addElement(packageRoot + ".");
    }

    public void addLoaderPackageRoot(String packageRoot) {
        this.loaderPackages.addElement(packageRoot + ".");
    }

    public Class forceLoadClass(String classname) throws ClassNotFoundException {
        this.log("force loading " + classname, 4);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findClass(classname);
        }
        return theClass;
    }

    public Class forceLoadSystemClass(String classname) throws ClassNotFoundException {
        this.log("force system loading " + classname, 4);
        Class theClass = this.findLoadedClass(classname);
        if (theClass == null) {
            theClass = this.findBaseClass(classname);
        }
        return theClass;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream resourceStream = null;
        if (this.isParentFirst(name)) {
            resourceStream = this.loadBaseResource(name);
            if (resourceStream != null) {
                this.log("ResourceStream for " + name + " loaded from parent loader", 4);
            } else {
                resourceStream = this.loadResource(name);
                if (resourceStream != null) {
                    this.log("ResourceStream for " + name + " loaded from ant loader", 4);
                }
            }
        } else {
            resourceStream = this.loadResource(name);
            if (resourceStream != null) {
                this.log("ResourceStream for " + name + " loaded from ant loader", 4);
            } else {
                resourceStream = this.loadBaseResource(name);
                if (resourceStream != null) {
                    this.log("ResourceStream for " + name + " loaded from parent loader", 4);
                }
            }
        }
        if (resourceStream == null) {
            this.log("Couldn't load ResourceStream for " + name, 4);
        }
        return resourceStream;
    }

    private InputStream loadResource(String name) {
        InputStream stream = null;
        Enumeration e = this.pathComponents.elements();
        while (e.hasMoreElements() && stream == null) {
            File pathComponent = (File)e.nextElement();
            stream = this.getResourceStream(pathComponent, name);
        }
        return stream;
    }

    private InputStream loadBaseResource(String name) {
        if (this.parent == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return this.parent.getResourceAsStream(name);
    }

    private InputStream getResourceStream(File file, String resourceName) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    return new FileInputStream(resource);
                }
            } else {
                ZipEntry entry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((entry = zipFile.getEntry(resourceName)) != null) {
                    return zipFile.getInputStream(entry);
                }
            }
        }
        catch (Exception e) {
            this.log("Ignoring Exception " + e.getClass().getName() + ": " + e.getMessage() + " reading resource " + resourceName + " from " + file, 3);
        }
        return null;
    }

    private boolean isParentFirst(String resourceName) {
        boolean useParentFirst = this.parentFirst;
        Enumeration e = this.systemPackages.elements();
        while (e.hasMoreElements()) {
            String packageName = (String)e.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = true;
            break;
        }
        Enumeration e2 = this.loaderPackages.elements();
        while (e2.hasMoreElements()) {
            String packageName = (String)e2.nextElement();
            if (!resourceName.startsWith(packageName)) continue;
            useParentFirst = false;
            break;
        }
        return useParentFirst;
    }

    public URL getResource(String name) {
        URL url = null;
        if (this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
        }
        if (url != null) {
            this.log("Resource " + name + " loaded from parent loader", 4);
        } else {
            Enumeration e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = (File)e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                this.log("Resource " + name + " loaded from ant loader", 4);
            }
        }
        if (url == null && !this.isParentFirst(name)) {
            URL uRL = url = this.parent == null ? super.getResource(name) : this.parent.getResource(name);
            if (url != null) {
                this.log("Resource " + name + " loaded from parent loader", 4);
            }
        }
        if (url == null) {
            this.log("Couldn't load Resource " + name, 4);
        }
        return url;
    }

    protected Enumeration findResources(String name) throws IOException {
        return new ResourceEnumeration(name);
    }

    private URL getResourceURL(File file, String resourceName) {
        try {
            if (!file.exists()) {
                return null;
            }
            if (file.isDirectory()) {
                File resource = new File(file, resourceName);
                if (resource.exists()) {
                    try {
                        return new URL("file:" + resource.toString());
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            } else {
                ZipEntry entry;
                ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
                if (zipFile == null) {
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                }
                if ((entry = zipFile.getEntry(resourceName)) != null) {
                    try {
                        return new URL("jar:file:" + file.toString() + "!/" + entry);
                    }
                    catch (MalformedURLException ex) {
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Class loadClass(String classname, boolean resolve) throws ClassNotFoundException {
        Class theClass = this.findLoadedClass(classname);
        if (theClass != null) {
            return theClass;
        }
        if (this.isParentFirst(classname)) {
            try {
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader", 4);
            }
            catch (ClassNotFoundException cnfe) {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader", 4);
            }
        } else {
            try {
                theClass = this.findClass(classname);
                this.log("Class " + classname + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreBase) {
                    throw cnfe;
                }
                theClass = this.findBaseClass(classname);
                this.log("Class " + classname + " loaded from parent loader", 4);
            }
        }
        if (resolve) {
            this.resolveClass(theClass);
        }
        return theClass;
    }

    private String getClassFilename(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private Class getClassFromStream(InputStream stream, String classname) throws IOException, SecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int bytesRead = -1;
        byte[] buffer = new byte[8192];
        while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] classData = baos.toByteArray();
        if (defineClassProtectionDomain != null) {
            try {
                Object domain = getProtectionDomain.invoke((Object)(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = AntClassLoader.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project), new Object[0]);
                Object[] args = new Object[]{classname, classData, new Integer(0), new Integer(classData.length), domain};
                return (Class)defineClassProtectionDomain.invoke((Object)this, args);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof ClassFormatError) {
                    throw (ClassFormatError)t;
                }
                if (t instanceof NoClassDefFoundError) {
                    throw (NoClassDefFoundError)t;
                }
                if (t instanceof SecurityException) {
                    throw (SecurityException)t;
                }
                throw new IOException(t.toString());
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        return this.defineClass(classname, classData, 0, classData.length);
    }

    public Class findClass(String name) throws ClassNotFoundException {
        this.log("Finding class " + name, 4);
        return this.findClassInComponents(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String name) throws ClassNotFoundException {
        InputStream stream = null;
        String classFilename = this.getClassFilename(name);
        try {
            Enumeration e = this.pathComponents.elements();
            while (true) {
                if (!e.hasMoreElements()) {
                    throw new ClassNotFoundException(name);
                }
                File pathComponent = (File)e.nextElement();
                try {
                    stream = this.getResourceStream(pathComponent, classFilename);
                    if (stream == null) continue;
                    Class clazz = this.getClassFromStream(stream, name);
                    Object var9_9 = null;
                    try {
                        if (stream == null) return clazz;
                        stream.close();
                        return clazz;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    return clazz;
                }
                catch (SecurityException se) {
                    throw se;
                }
                catch (IOException ioe) {
                    this.log("Exception reading component " + pathComponent, 3);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (IOException e2) {
                throw throwable;
            }
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
    }

    private Class findBaseClass(String name) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(name);
        }
        return this.parent.loadClass(name);
    }

    public synchronized void cleanup() {
        Enumeration e = this.zipFiles.elements();
        while (e.hasMoreElements()) {
            ZipFile zipFile = (ZipFile)e.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.zipFiles = new Hashtable();
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        this.project.removeBuildListener((BuildListener)this);
        this.project = null;
        this.cleanup();
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void messageLogged(BuildEvent event) {
    }

    private void addJavaLibraries() {
        Vector packages = JavaEnvUtils.getJrePackages();
        Enumeration e = packages.elements();
        while (e.hasMoreElements()) {
            String packageName = (String)e.nextElement();
            this.addSystemPackageRoot(packageName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            getProtectionDomain = (class$java$lang$Class == null ? (class$java$lang$Class = AntClassLoader.class$("java.lang.Class")) : class$java$lang$Class).getMethod("getProtectionDomain", new Class[0]);
            Class<?> protectionDomain = Class.forName("java.security.ProtectionDomain");
            Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = AntClassLoader.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = AntClassLoader.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE, protectionDomain};
            defineClassProtectionDomain = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = AntClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String name) {
            this.resourceName = name;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL ret = this.nextResource;
            this.findNextResource();
            return ret;
        }

        private void findNextResource() {
            URL url = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && url == null) {
                try {
                    File pathComponent = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    url = AntClassLoader.this.getResourceURL(pathComponent, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
            this.nextResource = url;
        }
    }
}

