/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.domain.dependency;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.graph.MutableDirectedGraph;
import org.apache.commons.graph.contract.Acyclic;
import org.apache.commons.graph.contract.AcyclicContract;
import org.apache.commons.graph.contract.Contract;
import org.apache.commons.graph.decorator.DDirectedGraph;
import org.apache.commons.graph.dependency.exception.CircularDependencyException;
import org.apache.commons.graph.domain.dependency.Dependency;
import org.apache.commons.graph.domain.dependency.DependencyVertex;
import org.apache.commons.graph.domain.dependency.DependencyVisitor;
import org.apache.commons.graph.exception.CycleException;
import org.apache.commons.graph.exception.GraphException;
import org.apache.commons.graph.factory.GraphFactory;

public class DependencyGraph
extends DDirectedGraph
implements Acyclic {
    private GraphFactory factory = new GraphFactory();
    private AcyclicContract acyclic = new AcyclicContract();
    private DependencyVisitor visitor = new DependencyVisitor();
    private Map vertices = new HashMap();
    private MutableDirectedGraph DAG = null;

    public DependencyGraph() {
        Contract[] dagContracts = new Contract[]{this.acyclic};
        this.DAG = this.factory.makeMutableDirectedGraph(dagContracts, false, null);
        this.setDirGraph(this.DAG);
    }

    private void init() {
    }

    public void addDependencies(Object head, Collection deps) throws GraphException, CircularDependencyException {
        DependencyVertex vHead = this.findVertex(head);
        if (!this.getVertices().contains(vHead)) {
            this.DAG.addVertex(vHead);
        }
        try {
            Iterator v = deps.iterator();
            while (v.hasNext()) {
                DependencyVertex vDep = this.findVertex(v.next());
                if (!this.getVertices().contains(vDep)) {
                    this.DAG.addVertex(vDep);
                }
                this.DAG.addEdge(new Dependency(vHead.getValue(), vDep.getValue()), vHead, vDep);
            }
        }
        catch (CycleException ex) {
            throw new CircularDependencyException(ex);
        }
    }

    public DependencyVertex findVertex(Object o) {
        if (this.vertices.containsKey(o)) {
            return (DependencyVertex)this.vertices.get(o);
        }
        DependencyVertex RC = new DependencyVertex(o);
        this.vertices.put(o, RC);
        return RC;
    }

    public List getSortedDependencies(Object head) {
        return this.visitor.getSortedDependencies(this, this.findVertex(head));
    }

    public List getSortedDependencies() {
        return this.visitor.getSortedDependencies(this);
    }
}

