/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.domain.basic;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.MutableGraph;
import org.apache.commons.graph.UndirectedGraph;
import org.apache.commons.graph.Vertex;
import org.apache.commons.graph.WeightedGraph;
import org.apache.commons.graph.exception.GraphException;

public class UndirectedGraphImpl
implements UndirectedGraph,
WeightedGraph,
MutableGraph,
InvocationHandler {
    private Set vertices = new HashSet();
    private Set edges = new HashSet();
    private Map edgeVerts = new HashMap();
    private Map vertEdges = new HashMap();
    private Map edgeWeights = new HashMap();

    public void addVertex(Vertex v) throws GraphException {
        this.vertices.add(v);
    }

    public void removeVertex(Vertex v) throws GraphException {
        this.vertices.remove(v);
    }

    public void removeEdge(Edge e) throws GraphException {
        this.edges.remove(e);
    }

    public void addEdge(Edge e) throws GraphException {
        this.edges.add(e);
    }

    public void disconnect(Edge e, Vertex v) {
        if (this.edgeVerts.containsKey(e)) {
            ((Set)this.edgeVerts.get(e)).remove(v);
        }
        if (this.vertEdges.containsKey(v)) {
            ((Set)this.vertEdges.get(v)).remove(e);
        }
    }

    public void connect(Edge e, Vertex v) {
        Set<Vertex> verts = null;
        if (!this.edgeVerts.containsKey(e)) {
            verts = new HashSet();
            this.edgeVerts.put(e, verts);
        } else {
            verts = (Set)this.edgeVerts.get(e);
        }
        verts.add(v);
        Set<Edge> edges = null;
        if (!this.vertEdges.containsKey(v)) {
            edges = new HashSet();
            this.vertEdges.put(v, edges);
        } else {
            edges = (Set)this.vertEdges.get(v);
        }
        edges.add(e);
    }

    public void addEdge(Edge e, Set vertices) throws GraphException {
        this.addEdge(e);
        Iterator verts = vertices.iterator();
        while (verts.hasNext()) {
            this.connect(e, (Vertex)verts.next());
        }
    }

    public Set getVertices() {
        return new HashSet(this.vertices);
    }

    public Set getVertices(Edge e) {
        if (this.edgeVerts.containsKey(e)) {
            return new HashSet((Set)this.edgeVerts.get(e));
        }
        return new HashSet();
    }

    public Set getEdges() {
        return new HashSet(this.edges);
    }

    public Set getEdges(Vertex v) {
        if (this.vertEdges.containsKey(v)) {
            return new HashSet((Set)this.vertEdges.get(v));
        }
        return new HashSet();
    }

    public void setWeight(Edge e, double w) {
        if (this.edgeWeights.containsKey(e)) {
            this.edgeWeights.remove(e);
        }
        this.edgeWeights.put(e, new Double(w));
    }

    public double getWeight(Edge e) {
        if (this.edgeWeights.containsKey(e)) {
            return (Double)this.edgeWeights.get(e);
        }
        return 1.0;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }
}

