/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.graph.algorithm.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.graph.Edge;
import org.apache.commons.graph.Path;
import org.apache.commons.graph.Vertex;

public class PathImpl
implements Path {
    protected List vertexList = new ArrayList();
    protected List edgeList = new ArrayList();

    public PathImpl(List vertexList, List edgeList) {
        this.vertexList = vertexList;
        this.edgeList = edgeList;
    }

    public PathImpl(Vertex start) {
        this.vertexList.add(start);
    }

    public PathImpl(Vertex start, Vertex end, Edge edge) {
        this.vertexList = new ArrayList();
        this.vertexList.add(start);
        this.vertexList.add(end);
        this.edgeList = new ArrayList();
        this.edgeList.add(edge);
    }

    public PathImpl append(PathImpl impl) {
        ArrayList newVertices = new ArrayList(this.vertexList);
        newVertices.remove(newVertices.size() - 1);
        newVertices.addAll(impl.getVertices());
        ArrayList newEdges = new ArrayList(this.edgeList);
        newEdges.addAll(impl.getEdges());
        return new PathImpl(newVertices, newEdges);
    }

    public PathImpl append(Vertex v, Edge e) {
        ArrayList<Vertex> newVertices = new ArrayList<Vertex>(this.vertexList);
        newVertices.add(v);
        ArrayList<Edge> newEdges = new ArrayList<Edge>(this.edgeList);
        newEdges.add(e);
        return new PathImpl(newVertices, newEdges);
    }

    public Vertex getStart() {
        return (Vertex)this.vertexList.get(0);
    }

    public Vertex getEnd() {
        return (Vertex)this.vertexList.get(this.vertexList.size() - 1);
    }

    public List getVertices() {
        return this.vertexList;
    }

    public List getEdges() {
        return this.edgeList;
    }

    public int size() {
        return this.vertexList.size();
    }

    public String toString() {
        return this.vertexList.toString();
    }
}

