/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.exceptions.TransferFailedException;

public class HttpDeployer
extends AbstractDeployer {
    private RepositoryInfo repoInfo;
    public static final String PROTOCOL = "http://";

    public void init(RepositoryInfo repoInfo) {
        this.repoInfo = repoInfo;
    }

    public void release() {
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        URL url = null;
        try {
            url = new URL(this.repoInfo.getUrl());
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.repoInfo.getUserName(), this.repoInfo.getPassword());
        HttpClient client = new HttpClient();
        client.setConnectionTimeout(5000);
        if (creds != null) {
            client.getState().setCredentials(null, (Credentials)creds);
        }
        HostConfiguration hc = new HostConfiguration();
        hc.setHost(this.repoInfo.getHost());
        client.setHostConfiguration(hc);
        PutMethod method = new PutMethod(url.getPath());
        try {
            method.setRequestBody((InputStream)new FileInputStream(request.getSrcFile()));
        }
        catch (FileNotFoundException io) {
            throw new TransferFailedException("input file: '" + request.getSrcFile() + " not found ");
        }
        method.setFollowRedirects(false);
        method.setStrictMode(false);
        try {
            client.executeMethod((HttpMethod)method);
        }
        catch (HttpException he) {
            System.err.println("Http error connecting to '" + url + "'");
            System.err.println(he.getMessage());
            System.exit(-4);
        }
        catch (IOException ioe) {
            System.err.println("Unable to connect to '" + url + "'");
            System.exit(-3);
        }
        Header[] requestHeaders = method.getRequestHeaders();
        Header[] responseHeaders = method.getResponseHeaders();
        byte[] responseBody = method.getResponseBody();
        method.releaseConnection();
    }
}

