/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.deploy.deployers;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.deploy.DeployRequest;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.deploy.deployers.AbstractDeployer;
import org.apache.maven.deploy.exceptions.TransferFailedException;

public class FileDeployer
extends AbstractDeployer {
    private RepositoryInfo repoInfo;
    public static final String PROTOCOL = "file://";

    public void init(RepositoryInfo repoInfo) {
        this.repoInfo = repoInfo;
    }

    public void release() {
    }

    public void deploy(DeployRequest request) throws TransferFailedException {
        try {
            File srcFile = new File(request.getSrcFile());
            File destFile = new File(this.repoInfo.getHost(), this.repoInfo.getBasedir());
            destFile = new File(destFile, request.dirname());
            if (!destFile.exists()) {
                destFile.mkdirs();
            }
            destFile = new File(destFile, request.filename());
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new TransferFailedException("Cannot copy file: " + e.getMessage());
        }
    }
}

