/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.deployer;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.MavenException;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.RepositoryInfoBuilder;
import org.apache.maven.deploy.DeployTool;
import org.apache.maven.deploy.RepositoryInfo;
import org.apache.maven.project.Project;
import org.apache.maven.util.MD5Sum;

public class DefaultArtifactDeployer
implements ArtifactDeployer {
    public static final boolean DEPLOY_POM = true;
    public static final boolean INSTALL_POM = true;
    public static final boolean DEPLOY_POM_SNAPSHOT = true;
    public static final boolean INSTALL_POM_SNAPSHOT = true;
    public static final DateFormat SNAPSHOT_SIGNATURE_FMT = new SimpleDateFormat("yyyyMMdd.HHmmss");

    public void deploy(String artifact, String type, Project project) throws MavenException {
        File file = "pom".equals(type) ? project.getFile() : this.getFileForArtifact(artifact);
        File md5File = this.createMD5Checksum(file);
        String repositoryPath = this.getRepositoryFullPath(type, project, project.getCurrentVersion());
        ArrayList<String> srcFiles = new ArrayList<String>();
        srcFiles.add(file.getAbsolutePath());
        srcFiles.add(md5File.getAbsolutePath());
        ArrayList<String> destFiles = new ArrayList<String>();
        destFiles.add(repositoryPath);
        destFiles.add(repositoryPath + ".md5");
        if (!"pom".equals(type)) {
            this.deploy(artifact, "pom", project);
        }
        this.doDeploy(srcFiles, destFiles, project);
        md5File.delete();
    }

    public void deploySnapshot(String artifact, String type, Project project) throws MavenException {
        String snapshotSignature = this.getSnapshotSignature();
        File file = "pom".equals(type) ? project.getFile() : this.getFileForArtifact(artifact);
        File md5File = this.createMD5Checksum(file);
        File snapshotVersionFile = this.createSnapshotVersionFile(file, snapshotSignature, project, type);
        ArrayList<String> srcFiles = new ArrayList<String>();
        srcFiles.add(file.getAbsolutePath());
        srcFiles.add(md5File.getAbsolutePath());
        srcFiles.add(file.getAbsolutePath());
        srcFiles.add(md5File.getAbsolutePath());
        srcFiles.add(snapshotVersionFile.getAbsolutePath());
        String snapshotFilename = this.getRepositoryFullPath(type, project, "SNAPSHOT");
        String timestampedFilename = this.getRepositoryFullPath(type, project, snapshotSignature);
        String snapshotVersionsFilename = this.getRepositoryDirectoryPath(type, project) + project.getArtifactId() + "-snapshot-version";
        ArrayList<String> destFiles = new ArrayList<String>();
        destFiles.add(snapshotFilename);
        destFiles.add(snapshotFilename + ".md5");
        destFiles.add(timestampedFilename);
        destFiles.add(timestampedFilename + ".md5");
        destFiles.add(snapshotVersionsFilename);
        if (!"pom".equals(type)) {
            this.deploySnapshot(artifact, "pom", project);
        }
        this.doDeploy(srcFiles, destFiles, project);
        md5File.delete();
    }

    public void install(String artifact, String type, Project project) throws MavenException {
        File file = "pom".equals(type) ? project.getFile() : this.getFileForArtifact(artifact);
        this.doInstall(file, type, project, project.getCurrentVersion());
        if (!"pom".equals(type)) {
            this.doInstall(project.getFile(), "pom", project, project.getCurrentVersion());
        }
    }

    public void installSnapshot(String artifact, String type, Project project) throws MavenException {
        File file = "pom".equals(type) ? project.getFile() : this.getFileForArtifact(artifact);
        String snapshotSignature = this.getSnapshotSignature();
        System.out.println("Installing snapshot of:'" + artifact + "''");
        this.doInstall(file, type, project, "SNAPSHOT");
        this.doInstall(file, type, project, snapshotSignature);
        if (!"pom".equals(type)) {
            File projectFile = project.getFile();
            this.doInstall(projectFile, "pom", project, "SNAPSHOT");
            this.doInstall(projectFile, "pom", project, snapshotSignature);
        }
    }

    private void doInstall(File file, String type, Project project, String version) throws MavenException {
        try {
            File destFile = new File(this.getLocalRepository(project), this.getRepositoryFullPath(type, project, version));
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            System.out.println("Copying: from '" + file + "' to: '" + destFile + "'");
            FileUtils.copyFile((File)file, (File)destFile);
        }
        catch (IOException e) {
            String msg = "Cannot install file: '" + file + "'. Reason: " + e.getMessage();
            throw new MavenException(msg, (Throwable)e);
        }
    }

    private void doDeploy(List srcFiles, List destFiles, Project project) throws MavenException {
        DeployTool deployTool = new DeployTool();
        String repoStr = (String)project.getContext().getVariable("maven.repo.list");
        if (repoStr == null || repoStr.length() == 0) {
            System.out.println("No remote repository was defined.");
            return;
        }
        String[] repos = StringUtils.split((String)repoStr, (String)",");
        System.out.println("Will deploy to " + repos.length + " repository(ies): " + repoStr);
        int i = 0;
        while (i < repos.length) {
            String repo = repos[i].trim();
            System.out.println("Deploying to repository: " + repo);
            RepositoryInfo repoInfo = null;
            try {
                repoInfo = RepositoryInfoBuilder.getRepositoryInfo(project, repo);
                deployTool.deploy(repoInfo, srcFiles, destFiles);
            }
            catch (Exception e) {
                String msg = "Failed to deploy to: " + repoInfo.getRepositoryAlias() + " Reason: " + e.getMessage();
                System.out.print(msg);
                e.printStackTrace();
            }
            ++i;
        }
    }

    private String getLocalRepository(Project project) {
        return project.getContext().getMavenRepoLocal();
    }

    private String getRepositoryFullPath(String type, Project project, String version) {
        StringBuffer path = new StringBuffer();
        path.append(project.getArtifactDirectory());
        path.append("/");
        path.append(type + "s");
        path.append("/");
        path.append(project.getArtifactId());
        path.append("-");
        path.append(version);
        path.append(".");
        path.append(this.extensionForType(type));
        return path.toString();
    }

    private String getRepositoryDirectoryPath(String type, Project project) {
        StringBuffer path = new StringBuffer();
        path.append(project.getArtifactDirectory());
        path.append("/");
        path.append(type + "s");
        path.append("/");
        return path.toString();
    }

    private String getSnapshotSignature() {
        Date now = new Date();
        return SNAPSHOT_SIGNATURE_FMT.format(now);
    }

    private File getFileForArtifact(String artifact) throws MavenException {
        File file = new File(artifact);
        if (!file.exists()) {
            String msg = "Artifact file: '" + artifact + "' must exist";
            throw new MavenException(msg);
        }
        if (!file.canRead()) {
            String msg = "Artifact file: '" + artifact + "' must be readable";
            throw new MavenException(msg);
        }
        if (file.isDirectory()) {
            String msg = "Artifact file: '" + artifact + "' must not be a directory";
            throw new MavenException(msg);
        }
        return file.getAbsoluteFile();
    }

    private File createSnapshotVersionFile(File artifact, String snapshotVersion, Project project, String type) throws MavenException {
        File file = null;
        String filename = project.getArtifactId() + "-" + type + "-snapshot-version";
        try {
            file = new File(artifact.getParent(), filename);
            FileUtils.fileWrite((String)file.getAbsolutePath(), (String)snapshotVersion);
        }
        catch (Exception e) {
            throw new MavenException("Cannot create snapshot-version file:" + file);
        }
        return file;
    }

    private File createMD5Checksum(File file) throws MavenException {
        MD5Sum md5Sum = new MD5Sum();
        md5Sum.setFile(file);
        try {
            md5Sum.execute();
        }
        catch (Exception e) {
            throw new MavenException("MD5 checksum error: " + e.getMessage(), (Throwable)e);
        }
        String checksum = md5Sum.getChecksum();
        File md5ChecksumFile = null;
        try {
            md5ChecksumFile = new File(file.getAbsoluteFile() + ".md5");
            FileUtils.fileWrite((String)md5ChecksumFile.getAbsolutePath(), (String)checksum);
        }
        catch (Exception e) {
            throw new MavenException("Cannot create md5 checksum file: " + md5ChecksumFile);
        }
        return md5ChecksumFile;
    }

    private String extensionForType(String type) {
        if (type.equals("ejb")) {
            return "jar";
        }
        return type;
    }

    static {
        SNAPSHOT_SIGNATURE_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

