/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.util.Stack;
import org.apache.commons.betwixt.io.AbstractBeanWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXBeanWriter
extends AbstractBeanWriter {
    private ContentHandler contentHandler;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$SAXBeanWriter == null ? (class$org$apache$commons$betwixt$io$SAXBeanWriter = SAXBeanWriter.class$("org.apache.commons.betwixt.io.SAXBeanWriter")) : class$org$apache$commons$betwixt$io$SAXBeanWriter));
    private Stack elementStack;
    private AttributesImpl attributes;
    private boolean elementWaiting = false;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$SAXBeanWriter;

    public SAXBeanWriter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    protected void expressElementStart(String qualifiedName) throws SAXException {
        if (this.elementStack == null) {
            this.elementStack = new Stack();
        }
        if (this.elementWaiting) {
            this.sendElementStart();
        }
        this.attributes = new AttributesImpl();
        this.elementStack.push(qualifiedName);
        this.elementWaiting = true;
    }

    protected void expressTagClose() {
    }

    protected void expressElementEnd(String qualifiedName) throws SAXException {
        if (this.elementWaiting) {
            this.elementWaiting = false;
            this.sendElementStart();
        }
        this.contentHandler.endElement("", "", qualifiedName);
    }

    protected void expressElementEnd() throws SAXException {
        String lastElement = (String)this.elementStack.peek();
        this.contentHandler.endElement("", "", lastElement);
    }

    protected void expressBodyText(String text) throws SAXException {
        if (this.elementWaiting) {
            this.elementWaiting = false;
            this.sendElementStart();
        }
        char[] body = text.toCharArray();
        this.contentHandler.characters(body, 0, body.length);
    }

    protected void expressAttribute(String qualifiedName, String value) throws SAXException {
        this.attributes.addAttribute("", "", qualifiedName, "CDATA", value);
    }

    private void sendElementStart() throws SAXException {
        String lastElement = (String)this.elementStack.peek();
        this.contentHandler.startElement("", "", lastElement, this.attributes);
    }

    public void start() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void end() throws SAXException {
        this.contentHandler.endDocument();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

