/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLIntrospector;
import org.apache.commons.betwixt.io.BeanCreateRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.XMLReader;

public class BeanReader
extends Digester {
    private XMLIntrospector introspector = new XMLIntrospector();
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanReader == null ? (class$org$apache$commons$betwixt$io$BeanReader = BeanReader.class$("org.apache.commons.betwixt.io.BeanReader")) : class$org$apache$commons$betwixt$io$BeanReader));
    private Set registeredClasses = new HashSet();
    private boolean matchIDs = true;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanReader;

    public BeanReader() {
    }

    public BeanReader(SAXParser parser) {
        super(parser);
    }

    public BeanReader(XMLReader reader) {
        super(reader);
    }

    public void registerBeanClass(Class beanClass) throws IntrospectionException {
        if (!this.registeredClasses.contains(beanClass)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Registering class " + beanClass));
            }
            this.registeredClasses.add(beanClass);
            XMLBeanInfo xmlInfo = this.introspector.introspect(beanClass);
            ElementDescriptor elementDescriptor = xmlInfo.getElementDescriptor();
            String path = elementDescriptor.getQualifiedName();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Added path: " + path + ", mapped to: " + beanClass.getName()));
            }
            this.addBeanCreateRule(path, elementDescriptor, beanClass);
            this.addBeanCreateRule("*/" + path, elementDescriptor, beanClass);
        }
    }

    public void registerBeanClass(String path, Class beanClass) throws IntrospectionException {
        if (!this.registeredClasses.contains(beanClass)) {
            this.registeredClasses.add(beanClass);
            XMLBeanInfo xmlInfo = this.introspector.introspect(beanClass);
            ElementDescriptor elementDescriptor = xmlInfo.getElementDescriptor();
            this.addBeanCreateRule(path, elementDescriptor, beanClass);
        } else {
            this.log.warn((Object)("Cannot add class " + beanClass.getName() + " since it already exists"));
        }
    }

    public XMLIntrospector getXMLIntrospector() {
        return this.introspector;
    }

    public void setXMLIntrospector(XMLIntrospector introspector) {
        this.introspector = introspector;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
        this.setLogger(log);
    }

    public boolean getMatchIDs() {
        return this.matchIDs;
    }

    public void setMatchIDs(boolean matchIDs) {
        this.matchIDs = matchIDs;
    }

    protected void addBeanCreateRule(String path, ElementDescriptor elementDescriptor, Class beanClass) {
        BeanCreateRule rule = new BeanCreateRule(elementDescriptor, beanClass, path + "/", this.matchIDs);
        this.addRule(path, rule);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added root rule to path: " + path + " rule: " + (Object)((Object)rule)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

