/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.RuleSupport;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementRule
extends RuleSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$ElementRule == null ? (class$org$apache$commons$betwixt$digester$ElementRule = ElementRule.class$("org.apache.commons.betwixt.digester.ElementRule")) : class$org$apache$commons$betwixt$digester$ElementRule));
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$ElementRule;

    public void begin(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        ElementDescriptor descriptor = new ElementDescriptor();
        descriptor.setQualifiedName(name);
        descriptor.setLocalName(name);
        String uri = attributes.getValue("uri");
        if (uri != null) {
            descriptor.setURI(uri);
        }
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        String propertyType = attributes.getValue("type");
        if (log.isTraceEnabled()) {
            log.trace((Object)("(BEGIN) name=" + name + " uri=" + uri + " property=" + propertyName + " type=" + propertyType));
        }
        descriptor.setPropertyType(this.getPropertyType(propertyType, this.beanClass, propertyName));
        if (propertyName != null && propertyName.length() > 0) {
            this.configureDescriptor(descriptor);
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            beanInfo.setElementDescriptor(descriptor);
            this.beanClass = beanInfo.getBeanClass();
        } else if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            parent.addElementDescriptor(descriptor);
        } else {
            throw new SAXException("Invalid use of <element>. It should be nested inside <info> or other <element> nodes");
        }
        this.digester.push((Object)descriptor);
    }

    public void end() {
        Object object = this.digester.pop();
    }

    protected Class getPropertyType(String propertyClassName, Class beanClass, String propertyName) {
        PropertyDescriptor descriptor;
        if (propertyClassName != null) {
            try {
                Class<?> answer = this.classLoader.loadClass(propertyClassName);
                if (answer != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Used specified type " + answer));
                    }
                    return answer;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Cannot load specified type", (Throwable)e);
            }
        }
        if ((descriptor = this.getPropertyDescriptor(beanClass, propertyName)) != null) {
            return descriptor.getPropertyType();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Cannot find property type.");
            log.trace((Object)("  className=" + propertyClassName + " base=" + beanClass + " name=" + propertyName));
        }
        return null;
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor) {
        String name;
        PropertyDescriptor descriptor;
        Class beanClass = this.getBeanClass();
        if (beanClass != null && (descriptor = this.getPropertyDescriptor(beanClass, name = elementDescriptor.getPropertyName())) != null) {
            XMLIntrospectorHelper.configureProperty(elementDescriptor, descriptor);
            this.getProcessedPropertyNameSet().add(name);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        if (beanClass != null && propertyName != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Searching for property " + propertyName + " on " + beanClass));
            }
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    int i = 0;
                    int size = descriptors.length;
                    while (i < size) {
                        PropertyDescriptor descriptor = descriptors[i];
                        if (propertyName.equals(descriptor.getName())) {
                            log.trace((Object)"Found matching method.");
                            return descriptor;
                        }
                        ++i;
                    }
                }
                log.trace((Object)"No match found.");
                return null;
            }
            catch (Exception e) {
                log.warn((Object)"Caught introspection exception", (Throwable)e);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

