/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.hibernate.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.tool.hbm2ddl.SchemaExport;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;

public class SchemaExportBean {
    private String includes = null;
    private String excludes = null;
    private String basedir = null;
    private String properties = null;
    private String config = null;
    private String outputFile = null;
    private boolean quiet = false;
    private boolean text = false;
    private boolean drop = false;

    public String getIncludes() {
        return this.includes;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public boolean getText() {
        return this.text;
    }

    public void setIncludes(String string) {
        this.includes = string;
    }

    public void setOutputFile(String string) {
        this.outputFile = string;
    }

    public void setQuiet(boolean b) {
        this.quiet = b;
    }

    public void setText(boolean b) {
        this.text = b;
    }

    public String getConfig() {
        return this.config;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public void setProperties(String string) {
        this.properties = string;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setBasedir(String string) {
        this.basedir = string;
    }

    public void setDrop(boolean b) {
        this.drop = b;
    }

    public void setExcludes(String string) {
        this.excludes = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        try {
            File baseDirFile = new File(this.getBasedir());
            URL[] urls = new URL[]{baseDirFile.toURL()};
            System.out.println(urls[0]);
            URLClassLoader newClassLoader = new URLClassLoader(urls, oldClassLoader);
            currentThread.setContextClassLoader(newClassLoader);
            Configuration cfg = this.getConfiguration();
            SchemaExport schemaExport = this.getSchemaExport(cfg);
            if (this.isDrop()) {
                schemaExport.drop(!this.getQuiet(), !this.getText());
            } else {
                schemaExport.create(!this.getQuiet(), !this.getText());
            }
            Object var9_8 = null;
            currentThread.setContextClassLoader(oldClassLoader);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            currentThread.setContextClassLoader(oldClassLoader);
            throw throwable;
        }
    }

    private String[] getFiles() {
        LinkedList<String> files = new LinkedList<String>();
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this.getBasedir());
        System.out.println("Excludes:" + this.getExcludes());
        System.out.println("Includes:" + this.getIncludes());
        System.out.println("Base dir:" + this.getBasedir());
        directoryScanner.setExcludes(StringUtils.split((String)this.getExcludes(), (String)","));
        directoryScanner.setIncludes(StringUtils.split((String)this.getIncludes(), (String)","));
        directoryScanner.scan();
        String[] includesFiles = directoryScanner.getIncludedFiles();
        int i = 0;
        while (i < includesFiles.length) {
            File file = new File(includesFiles[i]);
            if (!file.isFile()) {
                file = new File(directoryScanner.getBasedir(), includesFiles[i]);
            }
            files.add(file.getAbsolutePath());
            ++i;
        }
        String[] retValue = files.toArray(new String[0]);
        return retValue;
    }

    private Configuration getConfiguration() throws HibernateException {
        Configuration cfg = new Configuration();
        if (this.getConfig() != null) {
            cfg.configure(this.getConfig());
        }
        String[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            String filename = files[i];
            if (filename.endsWith(".jar")) {
                cfg.addJar(filename);
            } else {
                cfg.addFile(filename);
            }
            ++i;
        }
        return cfg;
    }

    private SchemaExport getSchemaExport(Configuration cfg) throws HibernateException, IOException {
        SchemaExport schemaExport = null;
        if (this.getProperties() == null) {
            schemaExport = new SchemaExport(cfg);
        } else {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.getProperties()));
            schemaExport = new SchemaExport(cfg, properties);
        }
        System.out.println("Output file:" + this.getOutputFile());
        schemaExport.setOutputFile(this.getOutputFile());
        return schemaExport;
    }
}

