/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.jxr.CodeTransform;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.tools.ant.DirectoryScanner;

public class JXR {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$maven$jxr$JxrBean == null ? (class$org$apache$maven$jxr$JxrBean = JXR.class$("org.apache.maven.jxr.JxrBean")) : class$org$apache$maven$jxr$JxrBean));
    public static final String NOTICE = "This page was automatically generated by <a href=\"http://maven.apache.org/\">Maven</a>";
    private String source = "";
    private String dest = "";
    private String javadocLinkDir;
    private CodeTransform transformer;
    private String revision;
    static /* synthetic */ Class class$org$apache$maven$jxr$JxrBean;

    public JXR(PackageManager packageManager, String source, String dest, String javadocLinkDir, String revision) {
        this.transformer = new CodeTransform(packageManager);
        this.source = source;
        this.dest = dest;
        this.javadocLinkDir = javadocLinkDir;
        this.revision = revision;
        this.process();
    }

    private void process() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.addDefaultExcludes();
        File dir = new File(this.getSource());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Your source directory does not exist and could not be created:" + this.getSource());
        }
        ds.setBasedir(this.getSource());
        ds.scan();
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            if (!this.updated(files[i])) {
                String source = this.getSource() + System.getProperty("file.separator") + files[i];
                try {
                    if (JXR.isJavaFile(source)) {
                        this.transform(source, this.getDestination(source));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static boolean isJavaFile(String filename) {
        return filename.endsWith(".java");
    }

    public static boolean isHtmlFile(String filename) {
        return filename.endsWith(".html");
    }

    private String getDestination(String filename) {
        String dest = new String(filename);
        dest = dest.substring(this.getSource().length(), dest.length());
        int start = 0;
        int end = dest.indexOf(".java");
        if (end != -1) {
            dest = dest.substring(start, end);
        }
        dest = this.getDest() + dest;
        dest = dest + ".html";
        return dest;
    }

    private void transform(String source, String dest) throws IOException {
        log.debug((Object)(source + " -> " + dest));
        this.transformer.transform(source, dest, this.javadocLinkDir, this.revision);
    }

    private boolean updated(String file) {
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public String getDest() {
        return this.dest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

