/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.ExportCodeSpec;
import com.ibm.ivj.util.base.ImportCodeSpec;
import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import com.ibm.ivj.util.base.Project;
import com.ibm.ivj.util.base.ProjectEdition;
import com.ibm.ivj.util.base.ToolEnv;
import com.ibm.ivj.util.base.Type;
import com.ibm.ivj.util.base.Workspace;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJProjectDescription;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.taskdefs.optional.ide.VAJWorkspaceScanner;

abstract class VAJLocalUtil
implements VAJUtil {
    private static Workspace workspace;

    VAJLocalUtil() {
    }

    static BuildException createBuildException(String errMsg, IvjException e) {
        errMsg = errMsg + "\n" + e.getMessage();
        String[] errors = e.getErrors();
        if (errors != null) {
            int i = 0;
            while (i < errors.length) {
                errMsg = errMsg + "\n" + errors[i];
                ++i;
            }
        }
        return new BuildException(errMsg, (Throwable)e);
    }

    static Workspace getWorkspace() {
        if (workspace == null && (workspace = ToolEnv.connectToWorkspace()) == null) {
            throw new BuildException("Unable to connect to Workspace! Make sure you are running in VisualAge for Java.");
        }
        return workspace;
    }

    public void exportPackages(File dest, String[] includePatterns, String[] excludePatterns, boolean exportClasses, boolean exportDebugInfo, boolean exportResources, boolean exportSources, boolean useDefaultExcludes, boolean overwrite) {
        if (includePatterns == null || includePatterns.length == 0) {
            this.log("You must specify at least one include attribute. Not exporting", 0);
        } else {
            try {
                VAJWorkspaceScanner scanner = new VAJWorkspaceScanner();
                scanner.setIncludes(includePatterns);
                scanner.setExcludes(excludePatterns);
                if (useDefaultExcludes) {
                    scanner.addDefaultExcludes();
                }
                scanner.scan();
                Package[] packages = scanner.getIncludedPackages();
                this.log("Exporting " + packages.length + " package(s) to " + dest, 2);
                int i = 0;
                while (i < packages.length) {
                    this.log("    " + packages[i].getName(), 3);
                    ++i;
                }
                ExportCodeSpec exportSpec = new ExportCodeSpec();
                exportSpec.setPackages(packages);
                exportSpec.includeJava(exportSources);
                exportSpec.includeClass(exportClasses);
                exportSpec.includeResources(exportResources);
                exportSpec.includeClassDebugInfo(exportDebugInfo);
                exportSpec.useSubdirectories(true);
                exportSpec.overwriteFiles(overwrite);
                exportSpec.setExportDirectory(dest.getAbsolutePath());
                VAJLocalUtil.getWorkspace().exportData(exportSpec);
            }
            catch (IvjException ex) {
                throw VAJLocalUtil.createBuildException("Exporting failed!", ex);
            }
        }
    }

    public void loadProjects(Vector projectDescriptions) {
        Vector expandedDescs = this.getExpandedDescriptions(projectDescriptions);
        Enumeration e = projectDescriptions.elements();
        while (e.hasMoreElements()) {
            VAJProjectDescription d = (VAJProjectDescription)e.nextElement();
            if (d.projectFound()) continue;
            this.log("No Projects match the name " + d.getName(), 1);
        }
        this.log("Loading " + expandedDescs.size() + " project(s) into workspace", 2);
        Enumeration e2 = expandedDescs.elements();
        while (e2.hasMoreElements()) {
            VAJProjectDescription d = (VAJProjectDescription)e2.nextElement();
            ProjectEdition pe = this.findProjectEdition(d.getName(), d.getVersion());
            try {
                this.log("Loading '" + d.getName() + "', Version '" + d.getVersion() + "', into Workspace", 3);
                pe.loadIntoWorkspace();
            }
            catch (IvjException ex) {
                throw VAJLocalUtil.createBuildException("Project '" + d.getName() + "' could not be loaded.", ex);
            }
        }
    }

    private Vector findMatchingProjects(String pattern) {
        String[] projectNames;
        try {
            projectNames = VAJLocalUtil.getWorkspace().getRepository().getProjectNames();
        }
        catch (IvjException e) {
            throw VAJLocalUtil.createBuildException("VA Exception occured: ", e);
        }
        Vector<String> matchingProjects = new Vector<String>();
        int i = 0;
        while (i < projectNames.length) {
            if (DirectoryScanner.match((String)pattern, (String)projectNames[i])) {
                matchingProjects.addElement(projectNames[i]);
            }
            ++i;
        }
        return matchingProjects;
    }

    private Vector getExpandedDescriptions(Vector projectDescs) {
        Vector<VAJProjectDescription> expandedDescs = new Vector<VAJProjectDescription>(projectDescs.size());
        try {
            String[] projectNames = VAJLocalUtil.getWorkspace().getRepository().getProjectNames();
            int i = 0;
            while (i < projectNames.length) {
                Enumeration e = projectDescs.elements();
                while (e.hasMoreElements()) {
                    VAJProjectDescription d = (VAJProjectDescription)e.nextElement();
                    String pattern = d.getName();
                    if (!DirectoryScanner.match((String)pattern, (String)projectNames[i])) continue;
                    d.setProjectFound();
                    expandedDescs.addElement(new VAJProjectDescription(projectNames[i], d.getVersion()));
                    break;
                }
                ++i;
            }
        }
        catch (IvjException e) {
            throw VAJLocalUtil.createBuildException("VA Exception occured: ", e);
        }
        return expandedDescs;
    }

    private ProjectEdition findProjectEdition(String name, String versionName) {
        try {
            ProjectEdition[] editions = null;
            editions = VAJLocalUtil.getWorkspace().getRepository().getProjectEditions(name);
            if (editions == null) {
                throw new BuildException("Project " + name + " doesn't exist");
            }
            ProjectEdition pe = null;
            int i = 0;
            while (i < editions.length && pe == null) {
                if (versionName.equals(editions[i].getVersionName())) {
                    pe = editions[i];
                }
                ++i;
            }
            if (pe == null) {
                throw new BuildException("Version " + versionName + " of Project " + name + " doesn't exist");
            }
            return pe;
        }
        catch (IvjException e) {
            throw VAJLocalUtil.createBuildException("VA Exception occured: ", e);
        }
    }

    public void importFiles(String importProject, File srcDir, String[] includePatterns, String[] excludePatterns, boolean importClasses, boolean importResources, boolean importSources, boolean useDefaultExcludes) throws BuildException {
        if (importProject == null || "".equals(importProject)) {
            throw new BuildException("The VisualAge for Java project name is required!");
        }
        ImportCodeSpec importSpec = new ImportCodeSpec();
        importSpec.setDefaultProject(VAJLocalUtil.getVAJProject(importProject));
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(srcDir);
        ds.setIncludes(includePatterns);
        ds.setExcludes(excludePatterns);
        if (useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
        ds.scan();
        Vector classes = new Vector();
        Vector sources = new Vector();
        Vector resources = new Vector();
        this.scanForImport(srcDir, ds.getIncludedFiles(), classes, sources, resources);
        StringBuffer summaryLog = new StringBuffer("Importing ");
        this.addFilesToImport(importSpec, importClasses, classes, "Class", summaryLog);
        this.addFilesToImport(importSpec, importSources, sources, "Java", summaryLog);
        this.addFilesToImport(importSpec, importResources, resources, "Resource", summaryLog);
        importSpec.setResourcePath(srcDir.getAbsolutePath());
        summaryLog.append(" into the project '");
        summaryLog.append(importProject);
        summaryLog.append("'.");
        this.log(summaryLog.toString(), 2);
        try {
            Type[] importedTypes = VAJLocalUtil.getWorkspace().importData(importSpec);
            if (importedTypes == null) {
                throw new BuildException("Unable to import into Workspace!");
            }
            this.log(importedTypes.length + " types imported", 4);
            int i = 0;
            while (i < importedTypes.length) {
                this.log(importedTypes[i].getPackage().getName() + "." + importedTypes[i].getName() + " into " + importedTypes[i].getProject().getName(), 4);
                ++i;
            }
        }
        catch (IvjException ivje) {
            throw VAJLocalUtil.createBuildException("Error while importing into workspace: ", ivje);
        }
    }

    static Project getVAJProject(String importProject) {
        Project found = null;
        Project[] currentProjects = VAJLocalUtil.getWorkspace().getProjects();
        int i = 0;
        while (i < currentProjects.length) {
            Project p = currentProjects[i];
            if (p.getName().equals(importProject)) {
                found = p;
                break;
            }
            ++i;
        }
        if (found == null) {
            try {
                found = VAJLocalUtil.getWorkspace().createProject(importProject, true);
            }
            catch (IvjException e) {
                throw VAJLocalUtil.createBuildException("Error while creating Project " + importProject + ": ", e);
            }
        }
        return found;
    }

    private void scanForImport(File dir, String[] files, Vector classes, Vector sources, Vector resources) {
        int i = 0;
        while (i < files.length) {
            String file = new File(dir, files[i]).getAbsolutePath();
            if (file.endsWith(".java") || file.endsWith(".JAVA")) {
                sources.addElement(file);
            } else if (file.endsWith(".class") || file.endsWith(".CLASS")) {
                classes.addElement(file);
            } else {
                resources.addElement(files[i]);
            }
            ++i;
        }
    }

    private void addFilesToImport(ImportCodeSpec spec, boolean doImport, Vector files, String fileType, StringBuffer summaryLog) {
        if (doImport) {
            Object[] fileArr = new String[files.size()];
            files.copyInto(fileArr);
            try {
                String methodName = "set" + fileType + "Files";
                Class[] methodParams = new Class[]{fileArr.getClass()};
                Method method = spec.getClass().getDeclaredMethod(methodName, methodParams);
                method.invoke((Object)spec, new Object[]{fileArr});
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            if (files.size() > 0) {
                this.logFiles(files, fileType);
                summaryLog.append(files.size());
                summaryLog.append(" " + fileType.toLowerCase() + " file");
                summaryLog.append(files.size() > 1 ? "s, " : ", ");
            }
        }
    }

    private void logFiles(Vector fileNames, String fileType) {
        this.log(fileType + " files found for import:", 3);
        Enumeration e = fileNames.elements();
        while (e.hasMoreElements()) {
            this.log("    " + e.nextElement(), 3);
        }
    }

    public abstract void log(String var1, int var2);
}

