/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import java.io.File;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.extension.LibraryDisplayer;
import org.apache.tools.ant.types.FileSet;

public class JarLibDisplayTask
extends Task {
    private File m_file;
    private final Vector m_filesets = new Vector();

    public void setFile(File file) {
        this.m_file = file;
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.addElement(fileSet);
    }

    public void execute() throws BuildException {
        this.validate();
        LibraryDisplayer displayer = new LibraryDisplayer();
        if (!this.m_filesets.isEmpty()) {
            Iterator iterator = ((AbstractList)this.m_filesets).iterator();
            while (iterator.hasNext()) {
                FileSet fileSet = (FileSet)iterator.next();
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                File basedir = scanner.getBasedir();
                String[] files = scanner.getIncludedFiles();
                int i = 0;
                while (i < files.length) {
                    File file = new File(basedir, files[i]);
                    displayer.displayLibrary(file);
                    ++i;
                }
            }
        } else {
            displayer.displayLibrary(this.m_file);
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_file && this.m_filesets.isEmpty()) {
            String message = "File attribute not specified.";
            throw new BuildException("File attribute not specified.");
        }
        if (null != this.m_file && !this.m_file.exists()) {
            String message = "File '" + this.m_file + "' does not exist.";
            throw new BuildException(message);
        }
        if (null != this.m_file && !this.m_file.isFile()) {
            String message = "'" + this.m_file + "' is not a file.";
            throw new BuildException(message);
        }
    }
}

