/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cvslib;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.changelog.AbstractChangeLogGenerator;
import org.apache.maven.project.Repository;
import org.apache.maven.util.AsyncStreamReader;
import org.apache.tools.ant.types.Commandline;

class CvsChangeLogGenerator
extends AbstractChangeLogGenerator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$maven$cvslib$CvsChangeLogGenerator == null ? (class$org$apache$maven$cvslib$CvsChangeLogGenerator = CvsChangeLogGenerator.class$("org.apache.maven.cvslib.CvsChangeLogGenerator")) : class$org$apache$maven$cvslib$CvsChangeLogGenerator));
    public static final int POS_SCM = 0;
    public static final int POS_SCM_TYPE = 1;
    public static final int POS_SCM_SUBTYPE = 2;
    public static final int POS_SCM_USERHOST = 3;
    public static final int POS_SCM_PATH = 4;
    public static final int POS_SCM_MODULE = 5;
    static /* synthetic */ Class class$org$apache$maven$cvslib$CvsChangeLogGenerator;

    CvsChangeLogGenerator() {
    }

    protected Commandline getScmLogCommand() {
        String[] tokens = Repository.splitSCMConnection((String)this.getConnection());
        if (!tokens[1].equals("cvs")) {
            throw new IllegalArgumentException("repository connection string does not specify 'cvs' as the scm");
        }
        Commandline command = new Commandline();
        command.setExecutable("cvs");
        command.createArgument().setValue("-d");
        String connectionBuffer = "";
        connectionBuffer = tokens[2].equalsIgnoreCase("local") ? tokens[4] : (tokens[2].equalsIgnoreCase("lserver") ? tokens[3] + ":" + tokens[4] : ":" + tokens[2] + ":" + tokens[3] + ":" + tokens[4]);
        command.createArgument().setValue(connectionBuffer.toString());
        command.createArgument().setValue("log");
        if (this.dateRange != null) {
            command.createArgument().setValue(this.dateRange);
        }
        return command;
    }

    protected String getScmDateArgument(Date before, Date to) {
        SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
        return "-d " + outputDate.format(before) + "<" + outputDate.format(to);
    }

    protected void handleParserException(IOException ioe) throws IOException {
        if (ioe.getMessage().indexOf("CreateProcess") != -1 || ioe.getMessage().indexOf("cvs: not found") != -1) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Unable to find cvs executable. Changelog will be empty");
            }
        } else {
            throw ioe;
        }
    }

    public void setProcessErrorStream(InputStream is) {
        this.errorReader = new CvsAsyncErrorReader(is);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CvsAsyncErrorReader
    extends AsyncStreamReader {
        public CvsAsyncErrorReader(InputStream anInputStream) {
            super(anInputStream);
        }

        protected boolean okToConsume(String line) {
            return !line.startsWith("cvs server: Logging");
        }
    }
}

