/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.j2ee.ValidationBroadcaster;
import org.apache.maven.j2ee.ValidationEvent;
import org.apache.maven.j2ee.ValidationFormatter;
import org.apache.maven.j2ee.ValidationListener;
import org.apache.maven.j2ee.ValidationStatusListener;
import org.apache.maven.j2ee.WarClassLoader;
import org.apache.maven.j2ee.WarFile;
import org.apache.maven.j2ee.war.FormLoginConfig;
import org.apache.tools.ant.BuildException;

public class WarValidator {
    private String warFileName;
    private ValidationBroadcaster broadcaster = new ValidationBroadcaster();
    private ValidationStatusListener status = new ValidationStatusListener();
    private boolean failOnError = true;

    public WarValidator() {
        this.addValidationListener(this.getStatus());
    }

    public ValidationStatusListener getStatus() {
        return this.status;
    }

    public void execute() throws BuildException {
        if (this.getWarFileName() == null) {
            throw new NullPointerException("war file name should not be null");
        }
        this.validate();
        if (this.getStatus().isError() && this.isFailOnError()) {
            throw new BuildException("Errors occurred during validation. Messages should have been provided");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        try {
            this.startValidation();
            this.validateFile();
            if (!this.getStatus().isError()) {
                this.validateWarContents();
            }
            Object var2_1 = null;
            this.endValidation();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endValidation();
            throw throwable;
        }
    }

    protected void startValidation() {
        this.getBroadcaster().fireStartedEvent(new ValidationEvent(this, this.getWarFileName(), "war validation started"));
    }

    protected void validateWarContents() {
        this.validateWebXml();
    }

    protected void endValidation() {
        this.getBroadcaster().fireEndedEvent(new ValidationEvent(this, this.getWarFileName(), "war validation ended"));
    }

    private void validateFile() {
        File warFile = new File(this.getWarFileName());
        if (!warFile.exists()) {
            this.error("File does not exist");
            return;
        }
        if (!warFile.canRead()) {
            this.error("File can't be read");
            return;
        }
    }

    private void validateWebXml() {
        WarFile war = null;
        try {
            war = new WarFile(this.getWarFileName());
            if (war.getWebXmlEntry() == null) {
                this.warning("web.xml entry not found");
                return;
            }
            this.validateServlets(war);
            this.validateJSPs(war);
            this.validateTaglibs(war);
            this.validateErrorPages(war);
            this.validateFormLoginConfig(war);
        }
        catch (IOException ioe) {
            this.error("Error opening war file for web.xml - possibly missing manifest");
        }
    }

    private void validateServlets(WarFile war) throws IOException {
        Map servlets = war.getServlets();
        if (servlets.size() != 0) {
            WarClassLoader classLoader = new WarClassLoader(war, this.getClass().getClassLoader());
            String className = null;
            Map.Entry entry = null;
            Iterator entries = servlets.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                className = (String)entry.getValue();
                this.info("validating servlet name: " + entry.getKey() + " class: " + className);
                this.validateClass(className, classLoader);
            }
        }
    }

    private void validateJSPs(WarFile war) throws IOException {
        Map jsps = war.getJSPs();
        if (jsps.size() != 0) {
            Map.Entry entry = null;
            Iterator entries = jsps.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                String jspFile = (String)entry.getValue();
                this.info("validating servlet name: " + entry.getKey() + " jsp file: " + jspFile);
                if (war.hasFile(jspFile)) continue;
                this.error("JSP File: '" + jspFile + "' not found");
            }
        }
    }

    protected void validateClass(String className, ClassLoader loader) {
        try {
            Class<?> clazz = loader.loadClass(className);
            if (clazz.getClassLoader() != loader) {
                this.error("class (" + className + ") loaded from system classpath " + "rather than war file");
            }
        }
        catch (ClassNotFoundException e) {
            this.error("class (" + className + ") not found ");
        }
        catch (NoClassDefFoundError error) {
            this.error("class (" + className + ") was found, but a referenced class " + "was missing: " + error.getMessage());
        }
    }

    private void validateTaglibs(WarFile war) throws IOException {
        Map taglibs = war.getTaglibs();
        if (taglibs.size() != 0) {
            Map.Entry entry = null;
            Iterator entries = taglibs.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                String uri = (String)entry.getKey();
                String location = (String)entry.getValue();
                this.info("validating taglib uri: " + uri);
                if (war.hasFile(location)) continue;
                this.error("Taglib location: '" + location + "' not found");
            }
        }
    }

    public void validateErrorPages(WarFile war) throws IOException {
        Map pages = war.getErrorPages();
        if (pages.size() != 0) {
            Map.Entry entry = null;
            Iterator entries = pages.entrySet().iterator();
            while (entries.hasNext()) {
                entry = entries.next();
                String errorQualifier = (String)entry.getKey();
                String location = (String)entry.getValue();
                this.info("validating error page for: " + errorQualifier);
                if (war.hasFile(location)) continue;
                this.error("Error page location: '" + location + "' not found");
            }
        }
    }

    public void validateFormLoginConfig(WarFile war) throws IOException {
        FormLoginConfig config = war.getFormLoginConfig();
        if (config != null) {
            if (!war.hasFile(config.getLoginPage())) {
                this.info("<form-config-login> login-page location: '" + config.getLoginPage() + "' not found");
            }
            if (!war.hasFile(config.getErrorPage())) {
                this.error("<form-config-login> error-page location: '" + config.getErrorPage() + "' not found");
            }
        }
    }

    public void addValidationListener(ValidationListener listener) {
        this.getBroadcaster().addValidationListener(listener);
    }

    public void removeValidationListener(ValidationListener listener) {
        this.getBroadcaster().removeValidationListener(listener);
    }

    public String getWarFileName() {
        return this.warFileName;
    }

    public void setWarFileName(String warFileName) {
        this.warFileName = warFileName;
    }

    protected ValidationBroadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public void addFormatter(ValidationFormatter formatter) {
        this.addValidationListener(formatter);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("WarValidator");
        if (this.getWarFileName() != null) {
            buffer.append("(").append(this.getWarFileName()).append(")");
        }
        return buffer.toString();
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    protected void info(String message) {
        this.getBroadcaster().fireInformationEvent(new ValidationEvent(this, this.getWarFileName(), message));
    }

    protected void error(String message) {
        this.getBroadcaster().fireErrorEvent(new ValidationEvent(this, this.getWarFileName(), message));
    }

    protected void warning(String message) {
        this.getBroadcaster().fireWarningEvent(new ValidationEvent(this, this.getWarFileName(), message));
    }
}

