/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.util.StringTool;

public class BaseObject {
    protected String id;
    private String name;
    private static int uniqueId;
    private Map properties;
    private List combinedProperties = new ArrayList();

    public void setName(String name) {
        this.name = StringTool.trim(name);
    }

    public String getName() {
        return this.name;
    }

    public void setId(String id) {
        this.id = StringTool.trim(id);
    }

    public String getId() {
        if (this.id == null || this.id.equals("")) {
            this.id = Integer.toString(uniqueId++);
        }
        return this.id;
    }

    public void addProperty(String combinedProperty) {
        this.combinedProperties.add(combinedProperty);
    }

    public String getProperty(String propertyName) {
        if (this.properties == null) {
            this.resolveProperties();
        }
        return (String)this.properties.get(propertyName);
    }

    public void setProperties(List combinedProperties) {
        this.combinedProperties = combinedProperties;
    }

    public List getProperties() {
        return this.combinedProperties;
    }

    public Map resolvedProperties() {
        if (this.properties == null) {
            this.resolveProperties();
        }
        return this.properties;
    }

    private void resolveProperties() {
        this.properties = new HashMap();
        Iterator i = this.combinedProperties.iterator();
        while (i.hasNext()) {
            String combinedProperty = (String)i.next();
            String[] s = StringUtils.split((String)combinedProperty, (String)":");
            if (s.length == 3) {
                this.properties.put(s[1], s[2]);
                continue;
            }
            this.properties.put(s[1], "");
        }
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (this.getId() != null) {
            return this.getId().equals(((BaseObject)o).getId());
        }
        return ((BaseObject)o).getId() == null;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    protected boolean isValid(String value) {
        return value != null && !value.trim().equals("");
    }
}

