/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.BaseObject;
import org.apache.maven.project.Branch;
import org.apache.maven.project.Build;
import org.apache.maven.project.Contributor;
import org.apache.maven.project.Dependency;
import org.apache.maven.project.Developer;
import org.apache.maven.project.License;
import org.apache.maven.project.MailingList;
import org.apache.maven.project.Organization;
import org.apache.maven.project.Project;
import org.apache.maven.project.Repository;
import org.apache.maven.project.Resource;
import org.apache.maven.project.SourceModification;
import org.apache.maven.project.UnitTest;
import org.apache.maven.project.Version;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefaultProjectUnmarshaller {
    public Project parse(Reader reader) throws Exception {
        Project project = new Project();
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(reader);
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                BaseObject d;
                BaseObject b;
                String id;
                if (parser.getName().equals("extend")) {
                    project.setExtend(parser.nextText());
                } else if (parser.getName().equals("pomVersion")) {
                    project.setPomVersion(parser.nextText());
                } else if (parser.getName().equals("groupId")) {
                    project.setGroupId(parser.nextText());
                } else if (parser.getName().equals("artifactId")) {
                    project.setArtifactId(parser.nextText());
                } else if (parser.getName().equals("id")) {
                    project.setId(parser.nextText());
                } else if (parser.getName().equals("name")) {
                    project.setName(parser.nextText());
                } else if (parser.getName().equals("currentVersion")) {
                    project.setCurrentVersion(parser.nextText());
                } else if (parser.getName().equals("inceptionYear")) {
                    project.setInceptionYear(parser.nextText());
                } else if (parser.getName().equals("package")) {
                    project.setPackage(parser.nextText());
                } else if (parser.getName().equals("gumpRepositoryId")) {
                    project.setGumpRepositoryId(parser.nextText());
                } else if (parser.getName().equals("description")) {
                    project.setDescription(parser.nextText());
                } else if (parser.getName().equals("shortDescription")) {
                    project.setShortDescription(parser.nextText());
                } else if (parser.getName().equals("url")) {
                    project.setUrl(parser.nextText());
                } else if (parser.getName().equals("issueTrackingUrl")) {
                    project.setIssueTrackingUrl(parser.nextText());
                } else if (parser.getName().equals("siteAddress")) {
                    project.setSiteAddress(parser.nextText());
                } else if (parser.getName().equals("siteDirectory")) {
                    project.setSiteDirectory(parser.nextText());
                } else if (parser.getName().equals("distributionDirectory")) {
                    project.setDistributionDirectory(parser.nextText());
                } else if (parser.getName().equals("organization")) {
                    project.setOrganization(new Organization());
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("name")) {
                            project.getOrganization().setName(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("url")) {
                            project.getOrganization().setUrl(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("logo")) {
                            project.getOrganization().setLogo(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("repository")) {
                    project.setRepository(new Repository());
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("connection")) {
                            project.getRepository().setConnection(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("developerConnection")) {
                            project.getRepository().setDeveloperConnection(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("url")) {
                            project.getRepository().setUrl(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("versions")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("version")) {
                            Version v = new Version();
                            project.addVersion(v);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("id")) {
                                    id = parser.nextText();
                                    v.setId(id);
                                    continue;
                                }
                                if (parser.getName().equals("name")) {
                                    v.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("tag")) {
                                    v.setTag(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("branches")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("branch")) {
                            b = new Branch();
                            project.addBranch((Branch)b);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("tag")) {
                                    ((Branch)b).setTag(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("mailingLists")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("mailingList")) {
                            MailingList ml = new MailingList();
                            project.addMailingList(ml);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("name")) {
                                    ml.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("subscribe")) {
                                    ml.setSubscribe(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("unsubscribe")) {
                                    ml.setUnsubscribe(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("archive")) {
                                    ml.setArchive(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("developers")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("developer")) {
                            d = new Developer();
                            project.addDeveloper((Developer)d);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("id")) {
                                    d.setId(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("name")) {
                                    d.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("email")) {
                                    ((Contributor)d).setEmail(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("organization")) {
                                    ((Contributor)d).setOrganization(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("roles")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("role")) {
                                            ((Contributor)d).addRole(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("contributors")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("contributor")) {
                            Contributor c = new Contributor();
                            project.addContributor(c);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("name")) {
                                    c.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("email")) {
                                    c.setEmail(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("roles")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("role")) {
                                            c.addRole(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("licenses")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("license")) {
                            License l = new License();
                            project.addLicense(l);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("name")) {
                                    l.setName(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("url")) {
                                    l.setUrl(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("distribution")) {
                                    l.setDistribution(parser.nextText());
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("dependencies")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("dependency")) {
                            d = new Dependency();
                            project.addDependency((Dependency)d);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("groupId")) {
                                    ((Dependency)d).setGroupId(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("artifactId")) {
                                    ((Dependency)d).setArtifactId(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("id")) {
                                    id = parser.nextText();
                                    ((Dependency)d).setId(id);
                                    continue;
                                }
                                if (parser.getName().equals("version")) {
                                    ((Dependency)d).setVersion(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("type")) {
                                    ((Dependency)d).setType(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("url")) {
                                    ((Dependency)d).setUrl(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("jar")) {
                                    ((Dependency)d).setJar(parser.nextText());
                                    continue;
                                }
                                if (parser.getName().equals("properties")) continue;
                                parser.nextText();
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("build")) {
                    b = new Build();
                    project.setBuild((Build)b);
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("nagEmailAddress")) {
                            ((Build)b).setNagEmailAddress(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("sourceDirectory")) {
                            ((Build)b).setSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("unitTestSourceDirectory")) {
                            ((Build)b).setUnitTestSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("aspectSourceDirectory")) {
                            ((Build)b).setAspectSourceDirectory(parser.nextText());
                            continue;
                        }
                        if (parser.getName().equals("unitTest")) {
                            UnitTest ut = new UnitTest();
                            ((Build)b).setUnitTest(ut);
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("includes")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("include")) {
                                            ut.addInclude(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                if (parser.getName().equals("excludes")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("exclude")) {
                                            ut.addExclude(parser.nextText());
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                if (parser.getName().equals("resources")) {
                                    while (parser.nextTag() == 2) {
                                        if (parser.getName().equals("resource")) {
                                            ut.addResource(this.unmarshalResource(parser));
                                            continue;
                                        }
                                        parser.nextText();
                                    }
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        if (parser.getName().equals("resources")) {
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("resource")) {
                                    ((Build)b).addResource(this.unmarshalResource(parser));
                                    continue;
                                }
                                parser.nextText();
                            }
                            continue;
                        }
                        if (parser.getName().equals("sourceModifications")) {
                            while (parser.nextTag() == 2) {
                                if (!parser.getName().equals("sourceModification")) continue;
                                SourceModification sm = new SourceModification();
                                ((Build)b).addSourceModification(sm);
                                while (parser.nextTag() == 2) {
                                    if (parser.getName().equals("className")) {
                                        sm.setClassName(parser.nextText());
                                        continue;
                                    }
                                    if (parser.getName().equals("includes")) {
                                        while (parser.nextTag() == 2) {
                                            if (parser.getName().equals("include")) {
                                                sm.addInclude(parser.nextText());
                                                continue;
                                            }
                                            parser.nextText();
                                        }
                                        continue;
                                    }
                                    if (parser.getName().equals("excludes")) {
                                        while (parser.nextTag() == 2) {
                                            if (parser.getName().equals("exclude")) {
                                                sm.addExclude(parser.nextText());
                                                continue;
                                            }
                                            parser.nextText();
                                        }
                                        continue;
                                    }
                                    parser.nextText();
                                }
                            }
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("reports")) {
                    while (parser.nextTag() == 2) {
                        if (parser.getName().equals("report")) {
                            project.addReport(parser.nextText());
                            continue;
                        }
                        parser.nextText();
                    }
                } else if (parser.getName().equals("properties")) {
                    // empty if block
                }
            }
            eventType = parser.next();
        }
        return project;
    }

    protected Map unmarshallProperties(XmlPullParser parser) throws XmlPullParserException, IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        while (parser.nextTag() == 2) {
            String key = parser.getName();
            String value = parser.nextText();
            properties.put(key, value);
        }
        return properties;
    }

    protected Resource unmarshalResource(XmlPullParser parser) throws XmlPullParserException, IOException {
        Resource r = new Resource();
        while (parser.nextTag() == 2) {
            if (parser.getName().equals("directory")) {
                r.setDirectory(parser.nextText());
                continue;
            }
            if (parser.getName().equals("targetPath")) {
                r.setTargetPath(parser.nextText());
                continue;
            }
            if (parser.getName().equals("includes")) {
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("include")) {
                        r.addInclude(parser.nextText());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            if (parser.getName().equals("excludes")) {
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("exclude")) {
                        r.addExclude(parser.nextText());
                        continue;
                    }
                    parser.nextText();
                }
                continue;
            }
            parser.nextText();
        }
        return r;
    }
}

