/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.wizards.nature;

import java.net.URI;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.wizards.project.NewMaskatProjectCreationPage;
import jp.sf.maskat.ui.wizards.project.PluginResourceData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;

public class AddMaskatNatureCreationPage
extends NewMaskatProjectCreationPage {
    public static final String PAGE_ID = "jp.sf.maskat.ui.addMaskatNatureCreationPage";

    public AddMaskatNatureCreationPage(IProject project, IPath path, boolean copy) {
        this(project, PAGE_ID, path, copy);
        this.setTitle(Messages.getString("wizard.nature.title"));
        this.setDescription(Messages.getString("wizard.nature.description"));
    }

    public AddMaskatNatureCreationPage(IProject project, String pageName, IPath path, boolean copy) {
        super(path, copy);
        this.setInitialProjectName(project.getName());
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = this.locationArea.getBrowseButton().getParent();
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(false);
            ++i;
        }
        this.projectLabel.setEnabled(false);
        this.projectNameField.setEnabled(false);
    }

    protected boolean validatePage() {
        if (this.maskatFWPath == null) {
            return false;
        }
        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String path = this.maskatFWPath.getText();
        if (path == null || path.length() == 0) {
            this.setErrorMessage(Messages.getString("wizard.project.msg.error.notfwpath"));
            this.maskatFWPath.setFocus();
            return false;
        }
        URI fwUrl = FileSystemSupportRegistry.getInstance().getDefaultConfiguration().getContributor().getURI(path);
        IProject handle = this.getProjectHandle();
        IStatus fwLocationStatus = workspace.validateProjectLocationURI(handle, fwUrl);
        if (!fwLocationStatus.isOK()) {
            this.setErrorMessage(fwLocationStatus.getMessage());
            this.maskatFWPath.setFocus();
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public PluginResourceData[] getSelectedPlugins() {
        Object[] select = this.viewer.getCheckedElements();
        PluginResourceData[] result = new PluginResourceData[select.length];
        int i = 0;
        while (i < select.length) {
            result[i] = (PluginResourceData)select[i];
            ++i;
        }
        return result;
    }
}

