/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.views.properties.tabbed.masterdetails;

import jp.sf.maskat.core.MaskatElement;
import jp.sf.maskat.core.event.Event;
import jp.sf.maskat.ui.MaskatNature;
import jp.sf.maskat.ui.Messages;
import jp.sf.maskat.ui.views.properties.tabbed.command.ChangeEventTypeCommand;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.AbstractMaskatDetailsPage;
import jp.sf.maskat.ui.views.properties.tabbed.masterdetails.EventPropertiesMasterDetailsBlock;
import jp.sf.maskat.ui.views.properties.tabbed.treenodewrapper.ITreeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.FileEditorInput;

public class EventHandlerDetailsPage
extends AbstractMaskatDetailsPage {
    private static final String SECTION_TEXT = Messages.getString("eventHandlerDetails.sectionText");
    private static final String DISABLED_DESCRIPTION = Messages.getString("eventHandlerDetails.disabledDescription");
    private static final String REMOTE_DESCRIPTION = Messages.getString("eventHandlerDetails.remoteDescription");
    private static final String LOCAL_DESCRIPTION = Messages.getString("eventHandlerDetails.localDescription");
    private static final String COMMUNICATION_TEXT = Messages.getString("eventHandlerDetails.communicationText");
    private static final String COMMUNICATION_DESCRIPTION = Messages.getString("eventHandlerDetails.communicationDescription");
    private static final String DISABLE_WARNING = Messages.getString("eventHandlerDetails.disableWarning");
    private static final String LOCAL_WARNING = Messages.getString("eventHandlerDetails.localWarning");
    private static final String WARNING_TITLE = Messages.getString("eventHandlerDetails.warningTitle");
    private Section eventSection;
    private Combo eventTypeCombo;
    private Event event;
    private Section communicationSection;
    private Text remoteURLText;
    private Button asyncButton;
    private Button syncButton;
    private String lastStateEventType = null;
    private Hyperlink openEventLink = null;
    private boolean lastStateEventIsEnabled = false;
    static /* synthetic */ Class class$0;

    public EventHandlerDetailsPage(TreeViewer masterBlockTreeViewer) {
        this.masterBlockTreeViewer = masterBlockTreeViewer;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 5;
        layout.bottomMargin = 5;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.managedForm.getToolkit();
        this.eventSection = toolkit.createSection(parent, 384);
        this.eventSection.setText(SECTION_TEXT);
        this.eventSection.setDescription(DISABLED_DESCRIPTION);
        TableWrapData tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        this.eventSection.setLayoutData((Object)tableWrapData);
        this.communicationSection = toolkit.createSection(parent, 384);
        this.communicationSection.setText(COMMUNICATION_TEXT);
        this.communicationSection.setDescription(COMMUNICATION_DESCRIPTION);
        tableWrapData = new TableWrapData(128, 16);
        tableWrapData.grabHorizontal = true;
        this.eventSection.setLayoutData((Object)tableWrapData);
        Composite eventComposite = toolkit.createComposite((Composite)this.eventSection);
        eventComposite.setLayout((Layout)new GridLayout(4, false));
        toolkit.createLabel(eventComposite, Messages.getString("eventHandlerDetails.eventLabel"));
        toolkit.createLabel(eventComposite, ":");
        this.eventTypeCombo = new Combo(eventComposite, 12);
        this.eventTypeCombo.add(Messages.getString("eventHandlerDetails.eventType.disabled"));
        this.eventTypeCombo.add(Messages.getString("eventHandlerDetails.eventType.remote"));
        this.eventTypeCombo.add(Messages.getString("eventHandlerDetails.eventType.local"));
        MaskatNature nature = this.getMaskatNature();
        if (nature != null && nature.getEventEditorContributor() != null) {
            this.openEventLink = toolkit.createHyperlink(eventComposite, Messages.getString("eventHandlerDetails.openHandlerImpl"), 0);
            this.openEventLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent ev) {
                    try {
                        EventHandlerDetailsPage.this.getMaskatNature().openEventHandlerImpl(EventHandlerDetailsPage.this.event);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        Composite communicationComposite = toolkit.createComposite((Composite)this.communicationSection);
        communicationComposite.setLayout((Layout)new GridLayout(4, false));
        toolkit.createLabel(communicationComposite, Messages.getString("eventHandlerDetails.remoteUrlLabel"));
        toolkit.createLabel(communicationComposite, ":");
        this.remoteURLText = toolkit.createText(communicationComposite, "", 2052);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        this.remoteURLText.setLayoutData((Object)gridData);
        toolkit.createLabel(communicationComposite, Messages.getString("eventHandlerDetails.communicationTypeLabel"));
        toolkit.createLabel(communicationComposite, ":");
        this.asyncButton = toolkit.createButton(communicationComposite, Messages.getString("eventHandlerDetails.asyncButtonLabel"), 16);
        this.syncButton = toolkit.createButton(communicationComposite, Messages.getString("eventHandlerDetails.syncButtonLabel"), 16);
        this.eventTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlerDetailsPage.this.updateEventType(EventHandlerDetailsPage.this.eventTypeCombo.getSelectionIndex());
                super.widgetSelected(e);
            }
        });
        this.remoteURLText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (EventHandlerDetailsPage.this.event.getRemoteUrl() == null || !EventHandlerDetailsPage.this.event.getRemoteUrl().equals(EventHandlerDetailsPage.this.remoteURLText.getText())) {
                    TreeViewer treeViewer = EventHandlerDetailsPage.this.masterBlockTreeViewer;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    EventPropertiesMasterDetailsBlock.setEventProperty(treeViewer, clazz, EventHandlerDetailsPage.this.event, "remoteUrl", EventHandlerDetailsPage.this.remoteURLText.getText());
                }
            }
        });
        this.remoteURLText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (EventHandlerDetailsPage.this.event.getRemoteUrl() == null || !EventHandlerDetailsPage.this.event.getRemoteUrl().equals(EventHandlerDetailsPage.this.remoteURLText.getText())) {
                    TreeViewer treeViewer = EventHandlerDetailsPage.this.masterBlockTreeViewer;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    EventPropertiesMasterDetailsBlock.setEventProperty(treeViewer, clazz, EventHandlerDetailsPage.this.event, "remoteUrl", EventHandlerDetailsPage.this.remoteURLText.getText());
                }
            }
        });
        this.asyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlerDetailsPage.this.updateCommunicationType(EventHandlerDetailsPage.this.asyncButton.getSelection());
            }
        });
        this.eventSection.setClient((Control)eventComposite);
        this.communicationSection.setClient((Control)communicationComposite);
    }

    private MaskatNature getMaskatNature() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
        MaskatNature nature = MaskatNature.getNature(file.getProject());
        return nature;
    }

    protected void initializeInterface() {
        this.lastStateEventIsEnabled = this.event.isEnable();
        this.lastStateEventType = this.event.getType();
        if (!this.event.isEnable()) {
            this.eventTypeCombo.select(0);
            this.eventSection.setDescription(DISABLED_DESCRIPTION);
            this.lastStateEventType = null;
            this.communicationSection.setVisible(false);
            if (this.openEventLink != null) {
                this.openEventLink.setVisible(false);
            }
        } else if (this.event.getType().equals("remote")) {
            this.eventTypeCombo.select(1);
            this.eventSection.setDescription(REMOTE_DESCRIPTION);
            if (this.event.getRemoteUrl() != null) {
                this.remoteURLText.setText(this.event.getRemoteUrl());
            } else {
                this.remoteURLText.setText("");
            }
            this.asyncButton.setSelection(this.event.isAsync());
            this.syncButton.setSelection(!this.event.isAsync());
            this.communicationSection.setVisible(true);
            if (this.openEventLink != null) {
                this.openEventLink.setVisible(true);
            }
        } else {
            this.eventTypeCombo.select(2);
            this.eventSection.setDescription(LOCAL_DESCRIPTION);
            this.communicationSection.setVisible(false);
            if (this.openEventLink != null) {
                this.openEventLink.setVisible(false);
            }
        }
        this.setStaleFlag(false);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (this.isDirty()) {
            this.update();
        }
    }

    public void update() {
        if (this.lastStateEventIsEnabled != this.event.isEnable()) {
            this.lastStateEventIsEnabled = this.event.isEnable();
        }
        if (this.event.getType() != null && !this.event.getType().equals(this.lastStateEventType)) {
            this.lastStateEventType = this.event.getType();
        }
        if (!this.event.isEnable()) {
            this.eventTypeCombo.select(0);
            this.eventSection.setDescription(DISABLED_DESCRIPTION);
            this.communicationSection.setVisible(false);
            this.lastStateEventType = null;
        } else if (this.event.getType().equals("remote")) {
            this.eventTypeCombo.select(1);
            this.eventSection.setDescription(REMOTE_DESCRIPTION);
            if (this.event.getRemoteUrl() != null) {
                this.remoteURLText.setText(this.event.getRemoteUrl());
            } else {
                this.remoteURLText.setText("");
            }
            if (this.event.isAsync()) {
                this.asyncButton.setSelection(true);
            } else {
                this.syncButton.setSelection(true);
            }
            this.communicationSection.setVisible(true);
        } else {
            this.eventTypeCombo.select(2);
            this.eventSection.setDescription(LOCAL_DESCRIPTION);
            this.communicationSection.setVisible(false);
        }
        this.setDirtyFlag(false);
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    protected void updateEventType(int selectionIndex) {
        boolean changeEventType = false;
        if (selectionIndex == 0) {
            if (this.lastStateEventIsEnabled) {
                changeEventType = this.showWarningDialog(DISABLE_WARNING);
                if (changeEventType) {
                    EventPropertiesMasterDetailsBlock.executeCommand(new ChangeEventTypeCommand(this.masterBlockTreeViewer, this.event, "disable"));
                }
                this.setDirtyFlag(true);
            }
        } else if (selectionIndex == 1) {
            EventPropertiesMasterDetailsBlock.executeCommand(new ChangeEventTypeCommand(this.masterBlockTreeViewer, this.event, "remote"));
            this.setDirtyFlag(true);
            if (this.openEventLink != null) {
                this.openEventLink.setVisible(true);
            }
        } else if (selectionIndex == 2) {
            if (this.lastStateEventType != null) {
                if (this.lastStateEventType.equals("remote")) {
                    changeEventType = this.showWarningDialog(LOCAL_WARNING);
                    if (changeEventType) {
                        EventPropertiesMasterDetailsBlock.executeCommand(new ChangeEventTypeCommand(this.masterBlockTreeViewer, this.event, "local"));
                    }
                    this.setDirtyFlag(true);
                }
            } else {
                EventPropertiesMasterDetailsBlock.executeCommand(new ChangeEventTypeCommand(this.masterBlockTreeViewer, this.event, "local"));
                this.setDirtyFlag(true);
            }
            if (this.openEventLink != null) {
                this.openEventLink.setVisible(false);
            }
        }
        if (this.isDirty()) {
            this.updateTreeViewer();
            this.update();
        }
    }

    private boolean showWarningDialog(String message) {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)WARNING_TITLE, (String)message);
    }

    private void updateTreeViewer() {
        ITreeNode treeNode;
        this.masterBlockTreeViewer.refresh();
        this.masterBlockTreeViewer.expandToLevel(2);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((treeNode = EventPropertiesMasterDetailsBlock.getTreeNode((MaskatElement)this.event, clazz)) != null) {
            this.masterBlockTreeViewer.setSelection((ISelection)new StructuredSelection((Object)treeNode), true);
        }
    }

    private void updateCommunicationType(boolean selection) {
        String select = selection ? "true" : "false";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sf.maskat.ui.views.properties.tabbed.beanwrapper.EventTreeNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventPropertiesMasterDetailsBlock.setEventProperty(this.masterBlockTreeViewer, clazz, this.event, "async", select);
        this.setDirtyFlag(true);
        this.update();
    }
}

