/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.maskat.ui.editors.layout.commands;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.gef.commands.Command;

public class SetPropertyCommand
extends Command {
    protected Object bean;
    private String propertyName;
    private Object oldValue;
    private Object newValue;

    public SetPropertyCommand(Object bean, String propertyName, Object newValue) {
        this.bean = bean;
        this.propertyName = propertyName;
        this.newValue = newValue;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        try {
            this.oldValue = BeanUtils.getProperty((Object)this.bean, (String)this.propertyName);
            BeanUtils.setProperty((Object)this.bean, (String)this.propertyName, (Object)this.newValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public void undo() {
        try {
            BeanUtils.setProperty((Object)this.bean, (String)this.propertyName, (Object)this.oldValue);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String getNewValue() {
        return this.newValue == null ? null : this.newValue.toString();
    }
}

